/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.service.HttpMetricFetcher;
import ai.vespa.metricsproxy.service.MetricsParser;
import ai.vespa.metricsproxy.service.VespaService;
import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class RemoteMetricsFetcher
extends HttpMetricFetcher {
    static final String METRICS_PATH = "/state/v1/metrics";

    RemoteMetricsFetcher(VespaService service, int port) {
        super(service, port, METRICS_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMetrics(MetricsParser.Consumer consumer, int fetchCount) {
        try (CloseableHttpResponse response = this.getResponse();){
            HttpEntity entity = response.getEntity();
            try {
                MetricsParser.parse(new BufferedInputStream(entity.getContent(), 262144), consumer);
            }
            catch (Exception e) {
                this.handleException(e, entity.getContentType(), fetchCount);
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void createMetrics(String data, MetricsParser.Consumer consumer, int fetchCount) throws IOException {
        MetricsParser.parse(data, consumer);
    }
}

