/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http.application;

import ai.vespa.metricsproxy.http.ValuesFetcher;
import ai.vespa.metricsproxy.http.application.MetricsNodesConfig;
import ai.vespa.metricsproxy.http.application.Node;
import ai.vespa.metricsproxy.http.application.NodeMetricsClient;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.util.http.hc5.VespaAsyncHttpClientBuilder;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import java.io.IOException;
import java.net.SocketException;
import java.time.Clock;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;

public class ApplicationMetricsRetriever
extends AbstractComponent
implements Runnable {
    private static final Logger log = Logger.getLogger(ApplicationMetricsRetriever.class.getName());
    static final Duration MIN_TIMEOUT = Duration.ofSeconds(60L);
    static final Duration MAX_TIMEOUT = Duration.ofSeconds(240L);
    private static final int HTTP_CONNECT_TIMEOUT = 5000;
    private static final int HTTP_SOCKET_TIMEOUT = 30000;
    private static final Duration METRICS_TTL = Duration.ofSeconds(30L);
    private final CloseableHttpAsyncClient httpClient = ApplicationMetricsRetriever.createHttpClient();
    private final List<NodeMetricsClient> clients;
    private final Thread pollThread;
    private final Set<ConsumerId> consumerSet;
    private long pollCount = 0L;
    private volatile boolean stopped;
    private volatile Duration taskTimeout;

    @Inject
    public ApplicationMetricsRetriever(MetricsNodesConfig nodesConfig) {
        this.clients = this.createNodeClients(nodesConfig);
        this.taskTimeout = ApplicationMetricsRetriever.timeout(this.clients.size());
        this.stopped = false;
        this.consumerSet = new HashSet<ConsumerId>();
        this.httpClient.start();
        this.pollThread = new Thread((Runnable)this, "metrics-poller");
        this.pollThread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    ConsumerId[] consumerIdArray = this.pollThread;
                    // MONITORENTER : this.pollThread
                    ConsumerId[] consumers = this.consumerSet.toArray(new ConsumerId[0]);
                    // MONITOREXIT : consumerIdArray
                    for (ConsumerId consumer : consumers) {
                        int numFailed = this.fetchMetricsAsync(consumer);
                        if (numFailed > 0) {
                            log.log(Level.INFO, "Updated metrics for consumer '" + consumer + "' failed for " + numFailed + " services");
                            continue;
                        }
                        log.log(Level.FINE, "Updated metrics for consumer '" + consumer + "'.");
                    }
                    Duration timeUntilNextPoll = Duration.ofMillis(1000L);
                    Thread thread = this.pollThread;
                    // MONITORENTER : thread
                    ++this.pollCount;
                    this.pollThread.notifyAll();
                    this.pollThread.wait(timeUntilNextPoll.toMillis());
                    if (this.stopped) {
                        // MONITOREXIT : thread
                        return;
                    }
                    // MONITOREXIT : thread
                }
            }
            catch (InterruptedException consumers) {
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Got unknown exception:", e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deconstruct() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            log.warning("Failed closing httpclient: " + e);
        }
        Thread thread = this.pollThread;
        synchronized (thread) {
            this.stopped = true;
            this.pollThread.notifyAll();
        }
        try {
            this.pollThread.join(Duration.ofSeconds(3L).toMillis());
            if (this.pollThread.isAlive()) {
                log.log(Level.WARNING, "metrics poller thread still not stopped, using Thread.interrupt():");
                this.pollThread.interrupt();
                this.pollThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.deconstruct();
    }

    Map<Node, List<MetricsPacket>> getMetrics() {
        return this.getMetrics(ValuesFetcher.defaultMetricsConsumerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Node, List<MetricsPacket>> getMetrics(ConsumerId consumer) {
        log.log(Level.FINE, () -> "Retrieving metrics from " + this.clients.size() + " nodes.");
        Thread thread = this.pollThread;
        synchronized (thread) {
            if (this.consumerSet.add(consumer)) {
                this.pollThread.notifyAll();
            }
        }
        HashMap<Node, List<MetricsPacket>> metrics = new HashMap<Node, List<MetricsPacket>>();
        for (NodeMetricsClient client : this.clients) {
            metrics.put(client.node, client.getMetrics(consumer));
        }
        return metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startPollAndWait() {
        try {
            Thread thread = this.pollThread;
            synchronized (thread) {
                if (!this.pollThread.isAlive()) {
                    this.pollThread.start();
                }
                long before = this.pollCount;
                this.pollThread.notifyAll();
                while (this.pollCount <= before + 1L) {
                    this.pollThread.notifyAll();
                    this.pollThread.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int fetchMetricsAsync(ConsumerId consumer) {
        HashMap futures = new HashMap();
        for (NodeMetricsClient client : this.clients) {
            client.startSnapshotUpdate(consumer, METRICS_TTL).ifPresent(future -> futures.put(client.node, future));
        }
        int numOk = 0;
        int numTried = futures.size();
        for (Map.Entry entry : futures.entrySet()) {
            if (this.stopped) break;
            try {
                ((Future)entry.getValue()).get(this.taskTimeout.toMillis(), TimeUnit.MILLISECONDS);
                ++numOk;
            }
            catch (InterruptedException | CancellationException | ExecutionException | TimeoutException e) {
                Throwable cause = e.getCause();
                if (this.stopped || e instanceof ExecutionException && (cause instanceof SocketException || cause instanceof ConnectTimeoutException)) {
                    log.log(Level.FINE, "Failed retrieving metrics for '" + entry.getKey() + "' : " + cause.getMessage());
                    continue;
                }
                log.log(Level.WARNING, "Failed retrieving metrics for '" + entry.getKey() + "' : ", e);
            }
        }
        log.log(Level.FINE, () -> "Finished retrieving metrics from " + this.clients.size() + " nodes.");
        return numTried - numOk;
    }

    private List<NodeMetricsClient> createNodeClients(MetricsNodesConfig nodesConfig) {
        return nodesConfig.node().stream().map(Node::new).map(node -> new NodeMetricsClient(this.httpClient, (Node)node, Clock.systemUTC())).collect(Collectors.toList());
    }

    static CloseableHttpAsyncClient createHttpClient() {
        return VespaAsyncHttpClientBuilder.create().setIOReactorConfig(IOReactorConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)30000L)).setIoThreadCount(2).build()).setUserAgent("application-metrics-retriever").setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)5000L)).setResponseTimeout(Timeout.ofMilliseconds((long)30000L)).build()).build();
    }

    static Duration timeout(int clients) {
        Duration timeout = Duration.ofSeconds(Long.max(MIN_TIMEOUT.toSeconds(), clients));
        return timeout.compareTo(MAX_TIMEOUT) > 0 ? MAX_TIMEOUT : timeout;
    }

    void setTaskTimeout(Duration taskTimeout) {
        this.taskTimeout = taskTimeout;
    }
}

