/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.rpc;

import ai.vespa.metricsproxy.core.MetricsManager;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.json.YamasJsonUtil;
import ai.vespa.metricsproxy.rpc.RpcConnector;
import ai.vespa.metricsproxy.service.VespaService;
import ai.vespa.metricsproxy.service.VespaServices;
import com.yahoo.collections.CollectionUtil;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Value;
import com.yahoo.security.tls.Capability;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RpcServer {
    private static final Logger log = Logger.getLogger(RpcServer.class.getName());
    private static final int LOG_SPENT_TIME_LIMIT = 10000;
    private final VespaServices vespaServices;
    private final MetricsManager metricsManager;

    public RpcServer(RpcConnector connector, VespaServices vespaServices, MetricsManager metricsManager) {
        this.vespaServices = vespaServices;
        this.metricsManager = metricsManager;
        this.addMethods(connector);
        log.log(Level.FINE, "RPC server created");
    }

    private void addMethods(RpcConnector connector) {
        connector.addMethod(new Method("setExtraMetrics", "s", "", this::setExtraMetrics).requireCapabilities(new Capability[]{Capability.METRICSPROXY__MANAGEMENT_API}).methodDesc("Set extra metrics that will be added to output from getMetricsForYamas.").paramDesc(0, "metricsJson", "The metrics in json format"));
        connector.addMethod(new Method("purgeExtraMetrics", "", "", this::purgeExtraMetrics).requireCapabilities(new Capability[]{Capability.METRICSPROXY__MANAGEMENT_API}).methodDesc("Purge metrics and dimensions populated by setExtraMetrics"));
        connector.addMethod(new Method("getMetricsById", "s", "s", this::getMetricsById).requireCapabilities(new Capability[]{Capability.METRICSPROXY__METRICS_API}).methodDesc("Get Vespa metrics for the service with the given Id").paramDesc(0, "id", "The id of the service").returnDesc(0, "ret", "Vespa metrics"));
        connector.addMethod(new Method("getServices", "", "s", this::getServices).requireCapabilities(new Capability[]{Capability.METRICSPROXY__METRICS_API}).methodDesc("Get Vespa services monitored by this metrics proxy").returnDesc(0, "ret", "Vespa metrics"));
        connector.addMethod(new Method("getMetricsForYamas", "s", "s", this::getMetricsForYamas).requireCapabilities(new Capability[]{Capability.METRICSPROXY__METRICS_API}).methodDesc("Get JSON formatted Vespa metrics for a given service name or 'all'").paramDesc(0, "service", "The vespa service name, or 'all'").returnDesc(0, "ret", "Vespa metrics"));
        connector.addMethod(new Method("getHealthMetricsForYamas", "s", "s", this::getHealthMetricsForYamas).requireCapabilities(new Capability[]{Capability.METRICSPROXY__METRICS_API}).methodDesc("Get JSON formatted Health check for a given service name or 'all'").paramDesc(0, "service", "The vespa service name").returnDesc(0, "ret", "Vespa metrics"));
        connector.addMethod(new Method("getAllMetricNamesForService", "ss", "s", this::getAllMetricNamesForService).requireCapabilities(new Capability[]{Capability.METRICSPROXY__METRICS_API}).methodDesc("Get metric names known for service ").paramDesc(0, "service", "The vespa service name'").paramDesc(1, "consumer", "The consumer'").returnDesc(0, "ret", "Metric names, one metric name per line"));
    }

    void getAllMetricNamesForService(Request req) {
        String service = req.parameters().get(0).asString();
        ConsumerId consumer = ConsumerId.toConsumerId(req.parameters().get(1).asString());
        RpcServer.withExceptionHandling(req, () -> {
            String metricNames = this.metricsManager.getMetricNamesForServiceAndConsumer(service, consumer);
            req.returnValues().add((Value)new StringValue(metricNames));
        });
    }

    void getMetricsById(Request req) {
        String id = req.parameters().get(0).asString();
        RpcServer.withExceptionHandling(req, () -> {
            String metricsString = this.metricsManager.getMetricsByConfigId(id);
            req.returnValues().add((Value)new StringValue(metricsString));
        });
    }

    void getServices(Request req) {
        RpcServer.withExceptionHandling(req, () -> {
            String servicesString = this.metricsManager.getAllVespaServices();
            req.returnValues().add((Value)new StringValue(servicesString));
        });
    }

    void getMetricsForYamas(Request req) {
        Instant startTime = Instant.now();
        req.detach();
        String service = req.parameters().get(0).asString();
        log.log(Level.FINE, () -> "getMetricsForYamas called at " + String.valueOf(startTime) + " with argument: " + service);
        List<VespaService> services = this.vespaServices.getMonitoringServices(service);
        log.log(Level.FINE, () -> "Getting metrics for services: " + CollectionUtil.mkString((Collection)services, (String)"[", (String)", ", (String)"]"));
        if (services.isEmpty()) {
            RpcServer.setNoServiceError(req, service);
        } else {
            RpcServer.withExceptionHandling(req, () -> {
                List<MetricsPacket> packets = YamasJsonUtil.appendOptionalStatusPacket(this.metricsManager.getMetrics(services, startTime));
                log.log(Level.FINE, () -> "Returning metrics packets:\n" + CollectionUtil.mkString((Collection)packets, (String)"\n"));
                req.returnValues().add((Value)new StringValue(YamasJsonUtil.toJson(packets, false)));
            });
        }
        req.returnRequest();
    }

    void getHealthMetricsForYamas(Request req) {
        req.detach();
        String service = req.parameters().get(0).asString();
        List<VespaService> services = this.vespaServices.getMonitoringServices(service);
        if (services.isEmpty()) {
            RpcServer.setNoServiceError(req, service);
        } else {
            RpcServer.withExceptionHandling(req, () -> {
                List<MetricsPacket> packets = YamasJsonUtil.appendOptionalStatusPacket(this.metricsManager.getHealthMetrics(services));
                req.returnValues().add((Value)new StringValue(YamasJsonUtil.toJson(packets, true)));
            });
        }
        req.returnRequest();
    }

    void setExtraMetrics(Request req) {
        String metricsJson = req.parameters().get(0).asString();
        log.log(Level.FINE, () -> "setExtraMetrics called with argument: " + metricsJson);
        RpcServer.withExceptionHandling(req, () -> this.metricsManager.setExtraMetrics(YamasJsonUtil.toMetricsPackets(metricsJson)));
    }

    void purgeExtraMetrics(Request req) {
        RpcServer.withExceptionHandling(req, this.metricsManager::purgeExtraMetrics);
    }

    private static void withExceptionHandling(Request req, ThrowingRunnable runnable) {
        try {
            TimeTracker timeTracker = new TimeTracker(req);
            runnable.run();
            timeTracker.logSpentTime();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Got exception when running RPC command " + req.methodName(), e);
            RpcServer.setMethodFailedError(req, e);
        }
        catch (Error e) {
            log.log(Level.WARNING, "Got error when running RPC command " + req.methodName(), e);
            RpcServer.setMethodFailedError(req, e);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Got throwable (non-error, non-exception) when running RPC command " + req.methodName(), t);
            RpcServer.setMethodFailedError(req, t);
        }
    }

    private static void setMethodFailedError(Request req, Throwable t) {
        String msg = "Request failed due to internal error: " + t.getClass().getName() + ": " + t.getMessage();
        req.setError(111, msg);
        req.returnValues().add((Value)new StringValue(""));
    }

    private static void setNoServiceError(Request req, String serviceName) {
        String msg = "No service with name '" + serviceName + "'";
        req.setError(105, msg);
        req.returnValues().add((Value)new StringValue(""));
    }

    private static interface ThrowingRunnable {
        public void run() throws Exception;
    }

    private static class TimeTracker {
        private final long startTime = System.currentTimeMillis();
        private final Request request;

        private TimeTracker(Request request) {
            this.request = request;
        }

        long spentTime() {
            return System.currentTimeMillis() - this.startTime;
        }

        private void logSpentTime() {
            Level logLevel = Level.FINE;
            if (this.spentTime() > 10000L) {
                logLevel = Level.INFO;
            }
            if (log.isLoggable(logLevel)) {
                log.log(logLevel, "RPC request '" + this.request.methodName() + "' with parameters '" + String.valueOf(this.request.parameters()) + "' took " + this.spentTime() + " ms");
            }
        }
    }
}

