/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.service.VespaService;
import ai.vespa.util.http.hc5.VespaHttpClientBuilder;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.util.Timeout;

public abstract class HttpMetricFetcher {
    private static final Logger log = Logger.getLogger(HttpMetricFetcher.class.getName());
    public static final String STATE_PATH = "/state/v1/";
    public static volatile int CONNECTION_TIMEOUT = 5000;
    private static final int SOCKET_TIMEOUT = 60000;
    static final int BUFFER_SIZE = 262144;
    private final URI url;
    protected final VespaService service;
    private static final CloseableHttpClient httpClient = HttpMetricFetcher.createHttpClient();

    HttpMetricFetcher(VespaService service, int port, String path) {
        this.service = service;
        String u = "http://localhost:" + port + path;
        this.url = URI.create(u);
        log.log(Level.FINE, () -> "Fetching metrics from " + u + " with timeout " + CONNECTION_TIMEOUT);
    }

    CloseableHttpResponse getResponse() throws IOException {
        log.log(Level.FINE, () -> "Connecting to url " + this.url + " for service '" + this.service + "'");
        return httpClient.execute((ClassicHttpRequest)new HttpGet(this.url));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " using " + this.url;
    }

    String errMsgNoResponse(Exception e) {
        return "Unable to get response from service '" + this.service + "': " + Exceptions.toMessageString((Throwable)e);
    }

    void handleException(Exception e, Object data, int timesFetched) {
        this.logMessage("Unable to parse json '" + data + "' for service '" + this.service + "': ", e, timesFetched);
    }

    private void logMessage(String message, Exception e, int timesFetched) {
        if (this.service.isAlive() && timesFetched > 5) {
            log.log(Level.INFO, message, e);
        } else {
            log.log(Level.FINE, message, e);
        }
    }

    void logMessageNoResponse(String message, int timesFetched) {
        if (timesFetched > 5) {
            log.log(Level.WARNING, message);
        } else {
            log.log(Level.INFO, message);
        }
    }

    private static CloseableHttpClient createHttpClient() {
        return VespaHttpClientBuilder.custom().connectTimeout(Timeout.ofMilliseconds((long)CONNECTION_TIMEOUT)).socketTimeout(Timeout.ofMilliseconds((long)60000L)).apacheBuilder().setUserAgent("metrics-proxy-http-client").setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofMilliseconds((long)CONNECTION_TIMEOUT)).setResponseTimeout(Timeout.ofMilliseconds((long)60000L)).build()).build();
    }
}

