/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http;

import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.core.MetricsManager;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.json.JsonRenderingException;
import ai.vespa.metricsproxy.service.VespaServices;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

public class ValuesFetcher {
    private static final Logger log = Logger.getLogger(ValuesFetcher.class.getName());
    public static final ConsumerId defaultMetricsConsumerId = ConsumerId.toConsumerId("default");
    private final MetricsManager metricsManager;
    private final VespaServices vespaServices;
    private final MetricsConsumers metricsConsumers;

    public ValuesFetcher(MetricsManager metricsManager, VespaServices vespaServices, MetricsConsumers metricsConsumers) {
        this.metricsManager = metricsManager;
        this.vespaServices = vespaServices;
        this.metricsConsumers = metricsConsumers;
    }

    public List<MetricsPacket> fetch(String requestedConsumer) throws JsonRenderingException {
        ConsumerId consumer = ValuesFetcher.getConsumerOrDefault(requestedConsumer, this.metricsConsumers);
        return this.metricsManager.getMetrics(this.vespaServices.getVespaServices(), Instant.now(), consumer).stream().filter(metricsPacket -> metricsPacket.consumers().contains(consumer)).toList();
    }

    public MetricsPacket.Builder[] fetchMetricsAsBuilders(String requestedConsumer) throws JsonRenderingException {
        ConsumerId consumer = ValuesFetcher.getConsumerOrDefault(requestedConsumer, this.metricsConsumers);
        List<MetricsPacket.Builder> builders = this.metricsManager.getMetricsAsBuilders(this.vespaServices.getVespaServices(), Instant.now(), consumer).stream().filter(builder -> builder.hasConsumer(consumer)).toList();
        return builders.toArray(new MetricsPacket.Builder[builders.size()]);
    }

    public List<MetricsPacket> fetchAllMetrics() throws JsonRenderingException {
        return this.metricsManager.getMetrics(this.vespaServices.getVespaServices(), Instant.now());
    }

    public static ConsumerId getConsumerOrDefault(String requestedConsumer, MetricsConsumers consumers) {
        if (requestedConsumer == null) {
            return defaultMetricsConsumerId;
        }
        Optional<ConsumerId> consumerId = consumers.getAllConsumers().stream().filter(consumer -> consumer.id.equalsIgnoreCase(requestedConsumer)).findFirst();
        if (consumerId.isPresent()) {
            return consumerId.get();
        }
        log.info("No consumer with id '" + requestedConsumer + "' - using the default consumer instead.");
        return defaultMetricsConsumerId;
    }
}

