/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http.yamas;

import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.core.MetricsManager;
import ai.vespa.metricsproxy.http.ValuesFetcher;
import ai.vespa.metricsproxy.http.yamas.YamasResponse;
import ai.vespa.metricsproxy.metric.dimensions.ApplicationDimensions;
import ai.vespa.metricsproxy.metric.dimensions.NodeDimensions;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.json.JsonRenderingException;
import ai.vespa.metricsproxy.node.NodeMetricGatherer;
import ai.vespa.metricsproxy.service.VespaServices;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.handler.metrics.ErrorResponse;
import com.yahoo.container.handler.metrics.HttpHandlerBase;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.restapi.Path;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;

public class YamasHandler
extends HttpHandlerBase {
    public static final String V1_PATH = "/yamas/v1";
    private static final String VALUES_PATH = "/yamas/v1/values";
    private final ValuesFetcher valuesFetcher;
    private final NodeMetricGatherer nodeMetricGatherer;

    @Inject
    public YamasHandler(Executor executor, MetricsManager metricsManager, VespaServices vespaServices, MetricsConsumers metricsConsumers, ApplicationDimensions applicationDimensions, NodeDimensions nodeDimensions) {
        super(executor);
        this.valuesFetcher = new ValuesFetcher(metricsManager, vespaServices, metricsConsumers);
        this.nodeMetricGatherer = new NodeMetricGatherer(metricsManager, vespaServices, applicationDimensions, nodeDimensions);
    }

    public Optional<HttpResponse> doHandle(URI requestUri, Path apiPath, String consumer) {
        if (apiPath.matches(V1_PATH)) {
            return Optional.of(this.resourceListResponse(requestUri, List.of(VALUES_PATH)));
        }
        if (apiPath.matches(VALUES_PATH)) {
            return Optional.of(this.valuesResponse(consumer));
        }
        return Optional.empty();
    }

    private HttpResponse valuesResponse(String consumer) {
        try {
            List<MetricsPacket> metrics = consumer == null ? this.valuesFetcher.fetchAllMetrics() : this.valuesFetcher.fetch(consumer);
            metrics.addAll(this.nodeMetricGatherer.gatherMetrics());
            return new YamasResponse(200, metrics);
        }
        catch (JsonRenderingException e) {
            return new ErrorResponse(500, e.getMessage());
        }
    }
}

