/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model.json;

import ai.vespa.metricsproxy.http.application.Node;
import ai.vespa.metricsproxy.metric.ExternalMetrics;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.ServiceId;
import ai.vespa.metricsproxy.metric.model.StatusCode;
import ai.vespa.metricsproxy.metric.model.json.GenericApplicationModel;
import ai.vespa.metricsproxy.metric.model.json.GenericJsonModel;
import ai.vespa.metricsproxy.metric.model.json.GenericMetrics;
import ai.vespa.metricsproxy.metric.model.json.GenericNode;
import ai.vespa.metricsproxy.metric.model.json.GenericService;
import ai.vespa.metricsproxy.metric.model.json.JacksonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class GenericJsonUtil {
    private static final Logger log = Logger.getLogger(GenericJsonUtil.class.getName());

    private GenericJsonUtil() {
    }

    public static GenericApplicationModel toGenericApplicationModel(Map<Node, List<MetricsPacket>> metricsByNode) {
        GenericApplicationModel applicationModel = new GenericApplicationModel();
        ArrayList<GenericJsonModel> genericJsonModels = new ArrayList<GenericJsonModel>();
        metricsByNode.forEach((node, metrics) -> genericJsonModels.add(GenericJsonUtil.toGenericJsonModel(metrics, node)));
        applicationModel.nodes = genericJsonModels;
        return applicationModel;
    }

    public static GenericJsonModel toGenericJsonModel(List<MetricsPacket> metricsPackets) {
        return GenericJsonUtil.toGenericJsonModel(metricsPackets, null);
    }

    public static GenericJsonModel toGenericJsonModel(List<MetricsPacket> metricsPackets, Node node) {
        Map packetsByService = metricsPackets.stream().collect(Collectors.groupingBy(packet -> packet.service, LinkedHashMap::new, Collectors.toList()));
        GenericJsonModel jsonModel = new GenericJsonModel();
        if (node != null) {
            jsonModel.hostname = node.hostname;
            jsonModel.role = node.role;
        }
        ArrayList<GenericService> genericServices = new ArrayList<GenericService>();
        packetsByService.forEach((serviceId, packets) -> {
            List<GenericMetrics> genericMetricsList = packets.stream().filter(packet -> !packet.metrics().isEmpty() || !packet.dimensions().isEmpty()).map(packet -> new GenericMetrics(packet.metrics(), packet.dimensions())).toList();
            GenericService genericService = packets.stream().findFirst().map(firstPacket -> new GenericService(serviceId.id, firstPacket.timestamp, StatusCode.values()[firstPacket.statusCode], firstPacket.statusMessage, genericMetricsList)).get();
            if (ExternalMetrics.VESPA_NODE_SERVICE_ID.equals(serviceId)) {
                jsonModel.node = new GenericNode(genericService.timestamp, genericService.metrics);
            } else {
                genericServices.add(genericService);
            }
        });
        jsonModel.services = genericServices;
        return jsonModel;
    }

    public static List<MetricsPacket.Builder> toMetricsPackets(String jsonString) {
        try {
            GenericJsonModel jsonModel = (GenericJsonModel)JacksonUtil.objectMapper().readValue(jsonString, GenericJsonModel.class);
            return GenericJsonUtil.toMetricsPackets(jsonModel);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not create metrics packet from string:\n" + jsonString, e);
            return List.of();
        }
    }

    public static List<MetricsPacket.Builder> toMetricsPackets(GenericJsonModel jsonModel) {
        List<MetricsPacket.Builder> packets = GenericJsonUtil.toNodePackets(jsonModel.node);
        jsonModel.services.forEach(genericService -> packets.addAll(GenericJsonUtil.toServicePackets(genericService)));
        return packets;
    }

    private static List<MetricsPacket.Builder> toNodePackets(GenericNode node) {
        ArrayList<MetricsPacket.Builder> packets = new ArrayList<MetricsPacket.Builder>();
        if (node == null) {
            return packets;
        }
        if (node.metrics == null || node.metrics.isEmpty()) {
            return List.of(new MetricsPacket.Builder(ExternalMetrics.VESPA_NODE_SERVICE_ID).statusCode(StatusCode.UP.ordinal()).timestamp(node.timestamp));
        }
        for (GenericMetrics genericMetrics : node.metrics) {
            MetricsPacket.Builder packet = new MetricsPacket.Builder(ExternalMetrics.VESPA_NODE_SERVICE_ID).statusCode(StatusCode.UP.ordinal()).timestamp(node.timestamp);
            GenericJsonUtil.addMetrics(genericMetrics, packet);
            packets.add(packet);
        }
        return packets;
    }

    private static List<MetricsPacket.Builder> toServicePackets(GenericService service) {
        ArrayList<MetricsPacket.Builder> packets = new ArrayList<MetricsPacket.Builder>();
        if (service.metrics == null || service.metrics.isEmpty()) {
            return List.of(GenericJsonUtil.newServicePacket(service));
        }
        for (GenericMetrics genericMetrics : service.metrics) {
            MetricsPacket.Builder packet = GenericJsonUtil.newServicePacket(service);
            GenericJsonUtil.addMetrics(genericMetrics, packet);
            packets.add(packet);
        }
        return packets;
    }

    private static MetricsPacket.Builder newServicePacket(GenericService service) {
        return new MetricsPacket.Builder(ServiceId.toServiceId(service.name)).statusCode(StatusCode.fromString(service.status.code).ordinal()).statusMessage(service.status.description).timestamp(service.timestamp);
    }

    private static void addMetrics(GenericMetrics genericMetrics, MetricsPacket.Builder packet) {
        genericMetrics.values.forEach((id, value) -> packet.putMetric(MetricId.toMetricId(id), (Number)value));
        genericMetrics.dimensions.forEach((id, value) -> packet.putDimension(DimensionId.toDimensionId(id), (String)value));
    }
}

