/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.core;

import ai.vespa.metricsproxy.core.VespaMetrics;
import ai.vespa.metricsproxy.metric.ExternalMetrics;
import ai.vespa.metricsproxy.metric.dimensions.ApplicationDimensions;
import ai.vespa.metricsproxy.metric.dimensions.NodeDimensions;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.service.VespaService;
import ai.vespa.metricsproxy.service.VespaServices;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MetricsManager {
    private static final Logger log = Logger.getLogger(MetricsManager.class.getName());
    static final DimensionId VESPA_VERSION = DimensionId.toDimensionId("vespaVersion");
    private final VespaServices vespaServices;
    private final VespaMetrics vespaMetrics;
    private final ExternalMetrics externalMetrics;
    private final ApplicationDimensions applicationDimensions;
    private final NodeDimensions nodeDimensions;
    private volatile Map<DimensionId, String> extraDimensions = new HashMap<DimensionId, String>();
    private volatile Instant externalMetricsUpdateTime = Instant.now();
    private static final Duration EXTERNAL_METRICS_TTL = Duration.ofMinutes(10L);

    public MetricsManager(VespaServices vespaServices, VespaMetrics vespaMetrics, ExternalMetrics externalMetrics, ApplicationDimensions applicationDimensions, NodeDimensions nodeDimensions) {
        this.vespaServices = vespaServices;
        this.vespaMetrics = vespaMetrics;
        this.externalMetrics = externalMetrics;
        this.applicationDimensions = applicationDimensions;
        this.nodeDimensions = nodeDimensions;
    }

    public String getMetricNamesForServiceAndConsumer(String service, ConsumerId consumer) {
        return this.vespaMetrics.getMetricNames(this.vespaServices.getMonitoringServices(service), consumer);
    }

    public String getMetricsByConfigId(String configId) {
        List<VespaService> services = this.vespaServices.getInstancesById(configId);
        this.vespaServices.updateServices(services);
        return this.vespaMetrics.getMetricsAsString(services);
    }

    public List<MetricsPacket> getMetrics(List<VespaService> services, Instant startTime) {
        MetricsPacket.Builder[] builderArray = this.getMetricsBuildersAsArray(services, startTime, null);
        ArrayList<MetricsPacket> metricsPackets = new ArrayList<MetricsPacket>(builderArray.length);
        for (int i = 0; i < builderArray.length; ++i) {
            metricsPackets.add(builderArray[i].build());
            builderArray[i] = null;
        }
        return metricsPackets;
    }

    public List<MetricsPacket> getMetrics(List<VespaService> services, Instant startTime, ConsumerId consumerId) {
        MetricsPacket.Builder[] builderArray = this.getMetricsBuildersAsArray(services, startTime, consumerId);
        ArrayList<MetricsPacket> metricsPackets = new ArrayList<MetricsPacket>(builderArray.length);
        for (int i = 0; i < builderArray.length; ++i) {
            metricsPackets.add(builderArray[i].build());
            builderArray[i] = null;
        }
        return metricsPackets;
    }

    private MetricsPacket.Builder[] getMetricsBuildersAsArray(List<VespaService> services, Instant startTime, ConsumerId consumerId) {
        List<MetricsPacket.Builder> builders = this.getMetricsAsBuilders(services, startTime, consumerId);
        return builders.toArray(new MetricsPacket.Builder[0]);
    }

    public List<MetricsPacket.Builder> getMetricsAsBuilders(List<VespaService> services, Instant startTime, ConsumerId consumerId) {
        if (services.isEmpty()) {
            return List.of();
        }
        log.log(Level.FINE, () -> "Updating services prior to fetching metrics, number of services= " + services.size());
        this.vespaServices.updateServices(services);
        List<MetricsPacket.Builder> result = this.vespaMetrics.getMetrics(services, consumerId);
        log.log(Level.FINE, () -> "Got " + result.size() + " metrics packets for vespa services.");
        this.purgeStaleMetrics();
        List<MetricsPacket.Builder> externalPackets = this.externalMetrics.getMetrics().stream().filter(MetricsPacket.Builder::hasMetrics).toList();
        log.log(Level.FINE, () -> "Got " + externalPackets.size() + " external metrics packets with whitelisted metrics.");
        result.addAll(externalPackets);
        Map<DimensionId, String> globalDims = this.getGlobalDimensions();
        return result.stream().map(builder -> builder.putDimensionsIfAbsent(globalDims)).map(builder -> builder.putDimensionsIfAbsent(this.extraDimensions)).map(builder -> MetricsManager.adjustTimestamp(builder, startTime)).toList();
    }

    private Map<DimensionId, String> getGlobalDimensions() {
        LinkedHashMap<DimensionId, String> globalDimensions = new LinkedHashMap<DimensionId, String>(this.applicationDimensions.getDimensions());
        globalDimensions.putAll(this.nodeDimensions.getDimensions());
        return globalDimensions;
    }

    static MetricsPacket.Builder adjustTimestamp(MetricsPacket.Builder builder, Instant startTime) {
        Duration age = Duration.between(startTime, builder.getTimestamp());
        if (age.abs().minusMinutes(1L).isNegative()) {
            builder.timestamp(startTime.getEpochSecond());
        }
        return builder;
    }

    public List<MetricsPacket> getHealthMetrics(List<VespaService> services) {
        if (services.isEmpty()) {
            return List.of();
        }
        this.vespaServices.updateServices(services);
        return this.vespaMetrics.getHealthMetrics(services);
    }

    public void setExtraMetrics(List<MetricsPacket.Builder> packets) {
        this.externalMetricsUpdateTime = Instant.now();
        this.extraDimensions = ExternalMetrics.extractConfigserverDimensions(packets);
        this.externalMetrics.setExtraMetrics(packets);
    }

    public Map<DimensionId, String> getExtraDimensions() {
        this.purgeStaleMetrics();
        return this.extraDimensions;
    }

    private void purgeStaleMetrics() {
        if (Duration.between(this.externalMetricsUpdateTime, Instant.now()).getSeconds() > EXTERNAL_METRICS_TTL.getSeconds()) {
            this.purgeExtraMetrics();
        }
    }

    public void purgeExtraMetrics() {
        this.extraDimensions = new HashMap<DimensionId, String>();
        this.externalMetrics.setExtraMetrics(List.of());
    }

    public String getAllVespaServices() {
        return this.vespaServices.getVespaServices().stream().map(VespaService::getServiceName).distinct().collect(Collectors.joining(" "));
    }
}

