/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model.prometheus;

import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.ServiceId;
import ai.vespa.metricsproxy.metric.model.prometheus.PrometheusModel;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PrometheusUtil {
    public static PrometheusModel toPrometheusModel(List<MetricsPacket> metricsPackets) {
        Map<ServiceId, List<MetricsPacket>> packetsByService = metricsPackets.stream().collect(Collectors.groupingBy(packet -> packet.service));
        ArrayList<Collector.MetricFamilySamples> metricFamilySamples = new ArrayList<Collector.MetricFamilySamples>(packetsByService.size());
        HashMap samples = new HashMap();
        packetsByService.forEach((serviceId, packets) -> {
            String serviceName = Collector.sanitizeMetricName((String)serviceId.id);
            for (MetricsPacket packet : packets) {
                Map<DimensionId, String> dimensions = packet.dimensions();
                ArrayList<String> labels = new ArrayList<String>(dimensions.size());
                ArrayList<String> labelValues = new ArrayList<String>(dimensions.size());
                for (Map.Entry<DimensionId, String> entry : dimensions.entrySet()) {
                    String labelName = Collector.sanitizeMetricName((String)entry.getKey().id);
                    labels.add(labelName);
                    labelValues.add(entry.getValue());
                }
                labels.add("vespa_service");
                labelValues.add(serviceName);
                for (Map.Entry<Object, Object> entry : packet.metrics().entrySet()) {
                    List<Collector.MetricFamilySamples.Sample> sampleList;
                    String metricName = Collector.sanitizeMetricName((String)((MetricId)entry.getKey()).id);
                    if (samples.containsKey(metricName)) {
                        sampleList = (List)samples.get(metricName);
                    } else {
                        sampleList = new ArrayList();
                        samples.put(metricName, sampleList);
                        metricFamilySamples.add(new Collector.MetricFamilySamples(metricName, Collector.Type.UNKNOWN, "", sampleList));
                    }
                    sampleList.add(new Collector.MetricFamilySamples.Sample(metricName, labels, labelValues, ((Number)entry.getValue()).doubleValue(), Long.valueOf(packet.timestamp * 1000L)));
                }
            }
            if (!packets.isEmpty()) {
                MetricsPacket firstPacket = (MetricsPacket)packets.get(0);
                String statusMetricName = serviceName + "_status";
                boolean statusMetricValue = firstPacket.statusCode == 0;
                List<Collector.MetricFamilySamples.Sample> sampleList = Collections.singletonList(new Collector.MetricFamilySamples.Sample(statusMetricName, Collections.emptyList(), Collections.emptyList(), (double)statusMetricValue, Long.valueOf(firstPacket.timestamp * 1000L)));
                metricFamilySamples.add(new Collector.MetricFamilySamples(statusMetricName, Collector.Type.UNKNOWN, "status of service", sampleList));
            }
        });
        return new PrometheusModel(metricFamilySamples);
    }
}

