/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.metric.HealthMetric;
import ai.vespa.metricsproxy.service.HttpMetricFetcher;
import ai.vespa.metricsproxy.service.VespaService;
import com.fasterxml.jackson.databind.JsonNode;
import com.yahoo.json.Jackson;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class RemoteHealthMetricFetcher
extends HttpMetricFetcher {
    private static final Logger log = Logger.getLogger(RemoteHealthMetricFetcher.class.getPackage().getName());
    private static final String HEALTH_PATH = "/state/v1/health";

    public RemoteHealthMetricFetcher(VespaService service, int port) {
        super(service, port, HEALTH_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public HealthMetric getHealth(int fetchCount) {
        try (CloseableHttpResponse response = this.getResponse();){
            HealthMetric healthMetric;
            HttpEntity entity = response.getEntity();
            try {
                healthMetric = this.parse(new BufferedInputStream(entity.getContent(), 262144));
            }
            catch (Exception e) {
                HealthMetric healthMetric2;
                block15: {
                    this.handleException(e, entity.getContentType(), fetchCount);
                    healthMetric2 = HealthMetric.getDown("Failed fetching status page for service");
                    EntityUtils.consumeQuietly((HttpEntity)entity);
                    if (response == null) break block15;
                    response.close();
                }
                return healthMetric2;
                {
                    catch (Throwable throwable) {
                        EntityUtils.consumeQuietly((HttpEntity)entity);
                        throw throwable;
                    }
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)entity);
            return healthMetric;
        }
        catch (IOException e) {
            if (this.service.isAlive()) {
                this.logMessageNoResponse(this.errMsgNoResponse(e), fetchCount);
            }
            return HealthMetric.getUnknown("Failed fetching metrics for service: " + this.service.getMonitoringName());
        }
    }

    private HealthMetric parse(InputStream data) {
        try {
            JsonNode o = Jackson.mapper().readTree(data);
            JsonNode status = o.get("status");
            String code = status.get("code").asText();
            String message = "";
            if (status.has("message")) {
                message = status.get("message").textValue();
            }
            return HealthMetric.get(code, message);
        }
        catch (IOException e) {
            log.log(Level.FINE, () -> "Failed to parse json response from metrics page:" + e + ":" + data);
            return HealthMetric.getUnknown("Not able to parse json from status page");
        }
    }
}

