/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.dimensions;

import ai.vespa.metricsproxy.metric.model.DimensionId;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

public enum BlocklistDimensions {
    APP("app"),
    APPLICATION_NAME("applicationName"),
    CLUSTER_NAME("clustername"),
    CLUSTER_ID("clusterid"),
    CLUSTER_TYPE("clustertype"),
    DEPLOYMENT_CLUSTER("deploymentCluster"),
    GROUP_ID("groupId"),
    INSTANCE("instance"),
    INSTANCE_NAME("instanceName"),
    TENANT_NAME("tenantName"),
    METRIC_TYPE("metrictype"),
    ORCHESTRATOR_STATE("orchestratorState"),
    ROLE("role"),
    STATE("state"),
    SYSTEM("system"),
    VESPA_VERSION("vespaVersion"),
    ARCHITECTURE("arch"),
    AUTHZ_REQUIRED("authz-equired"),
    HOME("home"),
    PORT("port"),
    SCHEME("scheme"),
    DRYRUN("dryrun"),
    VERSION("version");

    private final DimensionId dimensionId;

    private BlocklistDimensions(String dimensionId) {
        this.dimensionId = DimensionId.toDimensionId(dimensionId);
    }

    public DimensionId getDimensionId() {
        return this.dimensionId;
    }

    public static Set<DimensionId> getAll() {
        return EnumSet.allOf(BlocklistDimensions.class).stream().map(BlocklistDimensions::getDimensionId).collect(Collectors.toSet());
    }
}

