/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.metric.HealthMetric;
import ai.vespa.metricsproxy.metric.Metric;
import ai.vespa.metricsproxy.metric.Metrics;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.ServiceId;
import ai.vespa.metricsproxy.service.DummyHealthMetricFetcher;
import ai.vespa.metricsproxy.service.DummyMetricsFetcher;
import ai.vespa.metricsproxy.service.MetricsParser;
import ai.vespa.metricsproxy.service.RemoteHealthMetricFetcher;
import ai.vespa.metricsproxy.service.RemoteMetricsFetcher;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class VespaService
implements Comparable<VespaService> {
    private static final Map<DimensionId, String> EMPTY_DIMENSIONS = Collections.emptyMap();
    private static final String DEFAULT_MONITORING_PREFIX = "vespa";
    public static final String SEPARATOR = ".";
    private final String instanceName;
    private final String configId;
    private final String serviceName;
    private final ServiceId serviceId;
    private final Map<DimensionId, String> dimensions;
    private volatile int pid = -1;
    private volatile String state = "UNKNOWN";
    private volatile boolean isAlive;
    private final AtomicReference<Metrics> systemMetrics = new AtomicReference();
    private final int statePort;
    private final RemoteHealthMetricFetcher remoteHealthMetricFetcher;
    private final RemoteMetricsFetcher remoteMetricsFetcher;
    private final AtomicInteger metricsFetchCount = new AtomicInteger(0);
    private final AtomicInteger healthFetchCount = new AtomicInteger(0);

    public static VespaService create(String name, String id, int statePort) {
        return VespaService.create(name, id, statePort, DEFAULT_MONITORING_PREFIX, EMPTY_DIMENSIONS);
    }

    public static VespaService create(String name, String id, int statePort, String monitoringName, Map<DimensionId, String> dimensions) {
        String serviceName = name.replaceAll("\\d*$", "");
        return new VespaService(serviceName, name, id, statePort, monitoringName, dimensions);
    }

    VespaService(String serviceName, String configId) {
        this(serviceName, serviceName, configId);
    }

    VespaService(String serviceName, String instanceName, String configId) {
        this(serviceName, instanceName, configId, -1, DEFAULT_MONITORING_PREFIX, EMPTY_DIMENSIONS);
    }

    private VespaService(String serviceName, String instanceName, String configId, int statePort, String monitoringPrefix, Map<DimensionId, String> dimensions) {
        this.serviceName = serviceName;
        this.instanceName = instanceName;
        this.serviceId = ServiceId.toServiceId(monitoringPrefix + SEPARATOR + serviceName);
        this.configId = configId;
        this.statePort = statePort;
        this.dimensions = dimensions;
        this.systemMetrics.set(new Metrics());
        this.isAlive = false;
        this.remoteMetricsFetcher = this.statePort > 0 ? new RemoteMetricsFetcher(this, this.statePort) : new DummyMetricsFetcher(this);
        this.remoteHealthMetricFetcher = this.statePort > 0 ? new RemoteHealthMetricFetcher(this, this.statePort) : new DummyHealthMetricFetcher(this);
    }

    public ServiceId getMonitoringName() {
        return this.serviceId;
    }

    @Override
    public int compareTo(VespaService other) {
        return this.getInstanceName().compareTo(other.getInstanceName());
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public Map<DimensionId, String> getDimensions() {
        return this.dimensions;
    }

    public HealthMetric getHealth() {
        HealthMetric healthMetric = this.remoteHealthMetricFetcher.getHealth(this.healthFetchCount.get());
        this.healthFetchCount.getAndIncrement();
        return healthMetric;
    }

    public Metrics getSystemMetrics() {
        return this.systemMetrics.get();
    }

    public void consumeMetrics(MetricsParser.Collector consumer) {
        this.remoteMetricsFetcher.getMetrics(consumer, this.metricsFetchCount.get());
        this.metricsFetchCount.getAndIncrement();
    }

    public final Metrics getMetrics() {
        CollectMetrics collector = new CollectMetrics();
        this.consumeMetrics(collector);
        return collector.metrics;
    }

    public String getConfigId() {
        return this.configId;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean isAlive() {
        return this.isAlive && this.pid >= 0;
    }

    public String toString() {
        return this.instanceName + ":" + this.pid + ":" + this.state + ":" + this.configId;
    }

    public void setAlive(boolean alive) {
        this.isAlive = alive;
    }

    public synchronized void setSystemMetrics(Metrics metrics) {
        this.systemMetrics.set(metrics);
    }

    private static class CollectMetrics
    implements MetricsParser.Collector {
        private final Metrics metrics = new Metrics();

        private CollectMetrics() {
        }

        @Override
        public void accept(Metric metric) {
            this.metrics.add(metric);
        }
    }
}

