/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.core.MonitoringConfig;
import ai.vespa.metricsproxy.service.SystemPoller;
import ai.vespa.metricsproxy.service.VespaServices;
import com.yahoo.container.di.componentgraph.Provider;
import java.time.Duration;

public class SystemPollerProvider
implements Provider<SystemPoller> {
    private final SystemPoller poller;

    public SystemPollerProvider(VespaServices services, MonitoringConfig monitoringConfig) {
        if (SystemPollerProvider.runningOnLinux()) {
            Duration interval = Duration.ofMinutes(monitoringConfig.intervalMinutes());
            this.poller = new SystemPoller(services.getVespaServices(), interval);
            this.poller.schedule(Duration.ofSeconds(5L));
        } else {
            this.poller = null;
        }
    }

    public void deconstruct() {
        if (this.poller != null) {
            this.poller.stop();
        }
    }

    public SystemPoller get() {
        if (this.poller == null) {
            throw new IllegalStateException("System poller is only available on Linux, current OS is" + SystemPollerProvider.getOs());
        }
        return this.poller;
    }

    public static boolean runningOnLinux() {
        return SystemPollerProvider.getOs().contains("nux");
    }

    private static String getOs() {
        return System.getProperty("os.name");
    }
}

