/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http.application;

import ai.vespa.metricsproxy.http.application.ClusterIdDimensionProcessor;
import ai.vespa.metricsproxy.http.application.Node;
import ai.vespa.metricsproxy.http.application.PublicDimensionsProcessor;
import ai.vespa.metricsproxy.http.application.ServiceIdDimensionProcessor;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.json.GenericJsonUtil;
import ai.vespa.metricsproxy.metric.model.processing.MetricsProcessor;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;

public class NodeMetricsClient {
    private static final Logger log = Logger.getLogger(NodeMetricsClient.class.getName());
    private static final int MAX_DIMENSIONS = 10;
    final Node node;
    private final CloseableHttpAsyncClient httpClient;
    private final Clock clock;
    private final Map<ConsumerId, Snapshot> snapshots = new ConcurrentHashMap<ConsumerId, Snapshot>();
    private final AtomicLong snapshotsRetrieved = new AtomicLong();

    NodeMetricsClient(CloseableHttpAsyncClient httpClient, Node node, Clock clock) {
        this.httpClient = httpClient;
        this.node = node;
        this.clock = clock;
    }

    List<MetricsPacket> getMetrics(ConsumerId consumer) {
        Snapshot snapshot = this.snapshots.get(consumer);
        return snapshot != null ? snapshot.metrics : List.of();
    }

    Optional<Future<?>> startSnapshotUpdate(ConsumerId consumer, Duration ttl) {
        Snapshot snapshot = this.snapshots.get(consumer);
        if (snapshot != null && snapshot.isValid(this.clock.instant(), ttl)) {
            return Optional.empty();
        }
        return Optional.of(this.retrieveMetrics(consumer));
    }

    private Future<?> retrieveMetrics(final ConsumerId consumer) {
        final String metricsUri = this.node.metricsUri(consumer).toString();
        log.log(Level.FINE, () -> "Retrieving metrics from host " + metricsUri);
        final CompletableFuture onDone = new CompletableFuture();
        this.httpClient.execute(SimpleRequestBuilder.get((String)metricsUri).build(), (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

            public void completed(SimpleHttpResponse result) {
                NodeMetricsClient.this.handleResponse(metricsUri, consumer, result.getBodyText());
                onDone.complete(null);
            }

            public void failed(Exception ex) {
                onDone.completeExceptionally(ex);
            }

            public void cancelled() {
                onDone.cancel(false);
            }
        });
        return onDone;
    }

    void handleResponse(String metricsUri, ConsumerId consumer, String respons) {
        List<MetricsPacket> metrics = NodeMetricsClient.processAndBuild(GenericJsonUtil.toMetricsPackets(respons), new ServiceIdDimensionProcessor(), new ClusterIdDimensionProcessor(), new PublicDimensionsProcessor(10));
        this.snapshotsRetrieved.incrementAndGet();
        log.log(Level.FINE, () -> "Successfully retrieved " + metrics.size() + " metrics packets from " + metricsUri);
        this.snapshots.put(consumer, new Snapshot(Instant.now(this.clock), metrics));
    }

    private static List<MetricsPacket> processAndBuild(List<MetricsPacket.Builder> builders, MetricsProcessor ... processors) {
        return builders.stream().map(builder -> MetricsProcessor.applyProcessors(builder, processors)).map(MetricsPacket.Builder::build).toList();
    }

    long snapshotsRetrieved() {
        return this.snapshotsRetrieved.get();
    }

    static class Snapshot {
        final Instant timestamp;
        final List<MetricsPacket> metrics;

        Snapshot(Instant timestamp, List<MetricsPacket> metrics) {
            this.timestamp = timestamp;
            this.metrics = metrics;
        }

        boolean isValid(Instant now, Duration ttl) {
            return this.metrics != null && !this.metrics.isEmpty() && now.isBefore(this.timestamp.plus(ttl));
        }
    }
}

