/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http;

import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.core.MetricsManager;
import ai.vespa.metricsproxy.http.ErrorResponse;
import ai.vespa.metricsproxy.http.JsonResponse;
import ai.vespa.metricsproxy.http.ValuesFetcher;
import ai.vespa.metricsproxy.metric.model.json.JsonRenderingException;
import ai.vespa.metricsproxy.service.VespaServices;
import com.google.inject.Inject;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.restapi.Path;
import java.net.URI;
import java.util.concurrent.Executor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MetricsHandler
extends ThreadedHttpRequestHandler {
    static final String V1_PATH = "/metrics/v1";
    static final String VALUES_PATH = "/metrics/v1/values";
    private final ValuesFetcher valuesFetcher;

    @Inject
    public MetricsHandler(Executor executor, MetricsManager metricsManager, VespaServices vespaServices, MetricsConsumers metricsConsumers) {
        super(executor);
        this.valuesFetcher = new ValuesFetcher(metricsManager, vespaServices, metricsConsumers);
    }

    public HttpResponse handle(HttpRequest request) {
        if (request.getMethod() != HttpRequest.Method.GET) {
            return new JsonResponse(405, "Only GET is supported");
        }
        Path path = new Path(request.getUri());
        if (path.matches(V1_PATH)) {
            return this.v1Response(request.getUri());
        }
        if (path.matches(VALUES_PATH)) {
            return this.valuesResponse(request);
        }
        return new ErrorResponse(404, "No content at given path");
    }

    private JsonResponse v1Response(URI requestUri) {
        try {
            return new JsonResponse(200, this.v1Content(requestUri));
        }
        catch (JSONException e) {
            this.log.warning("Bad JSON construction in /metrics/v1 response: " + e.getMessage());
            return new ErrorResponse(500, "An error occurred, please try path '/metrics/v1/values'");
        }
    }

    private JsonResponse valuesResponse(HttpRequest request) {
        try {
            return new JsonResponse(200, this.valuesFetcher.fetch(request.getProperty("consumer")));
        }
        catch (JsonRenderingException e) {
            return new ErrorResponse(500, e.getMessage());
        }
    }

    private String v1Content(URI requestUri) throws JSONException {
        int port = requestUri.getPort();
        String host = requestUri.getHost();
        StringBuilder base = new StringBuilder("http://");
        base.append(host);
        if (port >= 0) {
            base.append(":").append(port);
        }
        String uriBase = base.toString();
        JSONArray linkList = new JSONArray();
        for (String api : new String[]{VALUES_PATH}) {
            JSONObject resource = new JSONObject();
            resource.put("url", (Object)(uriBase + api));
            linkList.put((Object)resource);
        }
        return new JSONObject().put("resources", (Object)linkList).toString(4);
    }
}

