/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JsonRenderingException
extends RuntimeException {
    private static Logger log = Logger.getLogger(JsonRenderingException.class.getName());

    JsonRenderingException(String message) {
        super(message);
    }

    public String getMessageAsJson() {
        return JsonRenderingException.wrap(this.getMessage());
    }

    private static String wrap(String message) {
        try {
            return new ObjectMapper().writeValueAsString(Map.of("error", message));
        }
        catch (JsonProcessingException e) {
            log.log(Level.WARNING, "Could not encode error message to json:", e);
            return "Could not encode error message to json, check the log for details.";
        }
    }
}

