/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric;

import ai.vespa.metricsproxy.core.ConsumersConfig;
import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.ServiceId;
import com.yahoo.log.LogLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ExternalMetrics {
    private static final Logger log = Logger.getLogger(ExternalMetrics.class.getName());
    public static final DimensionId ROLE_DIMENSION = DimensionId.toDimensionId("role");
    public static final DimensionId STATE_DIMENSION = DimensionId.toDimensionId("state");
    public static final DimensionId ORCHESTRATOR_STATE_DIMENSION = DimensionId.toDimensionId("orchestratorState");
    public static final ServiceId VESPA_NODE_SERVICE_ID = ServiceId.toServiceId("vespa.node");
    private volatile List<MetricsPacket.Builder> metrics = new ArrayList<MetricsPacket.Builder>();
    private final MetricsConsumers consumers;

    public ExternalMetrics(MetricsConsumers consumers) {
        this.consumers = consumers;
    }

    public List<MetricsPacket.Builder> getMetrics() {
        return this.metrics;
    }

    public void setExtraMetrics(List<MetricsPacket.Builder> externalPackets) {
        log.log((Level)LogLevel.DEBUG, () -> "Setting new external metrics with " + externalPackets.size() + " metrics packets.");
        externalPackets.forEach(packet -> packet.addConsumers(this.consumers.getAllConsumers()).service(VESPA_NODE_SERVICE_ID).retainMetrics(this.metricsToRetain()).applyOutputNames(this.outputNamesById()));
        this.metrics = List.copyOf(externalPackets);
    }

    private Set<MetricId> metricsToRetain() {
        return this.consumers.getConsumersByMetric().keySet().stream().map(configuredMetric -> MetricId.toMetricId(configuredMetric.name())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Map<MetricId, List<String>> outputNamesById() {
        LinkedHashMap<MetricId, List<String>> outputNamesById = new LinkedHashMap<MetricId, List<String>>();
        for (ConsumersConfig.Consumer.Metric metric : this.consumers.getConsumersByMetric().keySet()) {
            MetricId id = MetricId.toMetricId(metric.name());
            outputNamesById.computeIfAbsent(id, unused -> new ArrayList()).add(metric.outputname());
        }
        return outputNamesById;
    }

    public static Map<DimensionId, String> extractConfigserverDimensions(Collection<MetricsPacket.Builder> packets) {
        HashMap<DimensionId, String> dimensions = new HashMap<DimensionId, String>();
        for (MetricsPacket.Builder packet : packets) {
            dimensions.putAll(packet.build().dimensions());
        }
        dimensions.keySet().retainAll(Set.of(ROLE_DIMENSION, STATE_DIMENSION, ORCHESTRATOR_STATE_DIMENSION));
        return dimensions;
    }
}

