/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model.json;

import ai.vespa.metricsproxy.metric.ExternalMetrics;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.ServiceId;
import ai.vespa.metricsproxy.metric.model.StatusCode;
import ai.vespa.metricsproxy.metric.model.json.GenericJsonModel;
import ai.vespa.metricsproxy.metric.model.json.GenericMetrics;
import ai.vespa.metricsproxy.metric.model.json.GenericNode;
import ai.vespa.metricsproxy.metric.model.json.GenericService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GenericJsonUtil {
    private GenericJsonUtil() {
    }

    public static GenericJsonModel toGenericJsonModel(List<MetricsPacket> metricsPackets) {
        Map<ServiceId, List<MetricsPacket>> packetsByService = metricsPackets.stream().collect(Collectors.groupingBy(packet -> packet.service));
        GenericJsonModel jsonModel = new GenericJsonModel();
        ArrayList<GenericService> genericServices = new ArrayList<GenericService>();
        packetsByService.forEach((serviceId, packets) -> {
            List genericMetricsList = packets.stream().map(packet -> new GenericMetrics(packet.metrics(), packet.dimensions())).collect(Collectors.toList());
            GenericService genericService = packets.stream().findFirst().map(firstPacket -> new GenericService(serviceId.id, firstPacket.timestamp, StatusCode.values()[firstPacket.statusCode], firstPacket.statusMessage, genericMetricsList)).get();
            if (ExternalMetrics.VESPA_NODE_SERVICE_ID.equals(serviceId)) {
                jsonModel.node = new GenericNode(genericService.timestamp, genericService.metrics);
            } else {
                genericServices.add(genericService);
            }
        });
        jsonModel.services = genericServices;
        return jsonModel;
    }
}

