/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.service.HttpMetricFetcher;
import ai.vespa.metricsproxy.service.MetricsParser;
import ai.vespa.metricsproxy.service.VespaService;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;

public class RemoteMetricsFetcher
extends HttpMetricFetcher {
    static final String METRICS_PATH = "/state/v1/metrics";

    RemoteMetricsFetcher(VespaService service, int port) {
        super(service, port, METRICS_PATH);
    }

    public void getMetrics(MetricsParser.Consumer consumer, int fetchCount) {
        try (InputStream stream = this.getJson();){
            this.createMetrics(stream, consumer, fetchCount);
        }
        catch (IOException | InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    void createMetrics(String data, MetricsParser.Consumer consumer, int fetchCount) throws IOException {
        MetricsParser.parse(data, consumer);
    }

    private void createMetrics(InputStream data, MetricsParser.Consumer consumer, int fetchCount) throws IOException {
        try {
            MetricsParser.parse(data, consumer);
        }
        catch (Exception e) {
            this.handleException(e, data, fetchCount);
            while (data.read() != -1) {
            }
        }
    }
}

