/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric;

import ai.vespa.metricsproxy.metric.Metric;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Metrics {
    private final List<Metric> metrics = new ArrayList<Metric>();
    private long timestamp;
    private boolean isFrozen = false;

    public Metrics() {
        this(System.currentTimeMillis() / 1000L);
    }

    public Metrics(long timestamp) {
        this.timestamp = timestamp;
    }

    private void ensureNotFrozen() {
        if (this.isFrozen) {
            throw new IllegalStateException("Frozen Metrics cannot be modified!");
        }
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public void setTimeStamp(long timestamp) {
        this.ensureNotFrozen();
        this.timestamp = timestamp;
    }

    public void add(Metric m) {
        this.ensureNotFrozen();
        this.timestamp = m.getTimeStamp();
        this.metrics.add(m);
    }

    public int size() {
        return this.metrics.size();
    }

    public Metric getMetric(String key) {
        this.isFrozen = true;
        for (Metric m : this.metrics) {
            if (!m.getName().equals(key)) continue;
            return m;
        }
        return null;
    }

    public List<Metric> getMetrics() {
        this.isFrozen = true;
        return Collections.unmodifiableList(this.metrics);
    }

    public Number get(String key) {
        this.isFrozen = true;
        Metric m = this.getMetric(key);
        if (m != null) {
            return m.getValue();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Metric m : this.metrics) {
            sb.append(m.getName()).append(":").append(m.getValue()).append("\n");
        }
        return sb.toString();
    }
}

