/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class VespaServicesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "1676493faba7589269977dbffa020ca2";
    public static final String CONFIG_DEF_NAME = "vespa-services";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.metricsproxy.service";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.metricsproxy.service", "service[].configId string", "service[].name string default=\"\"", "service[].port int default=-1", "service[].dimension[].key string", "service[].dimension[].value string"};
    private final InnerNodeVector<Service> service;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public VespaServicesConfig(Builder builder) {
        this(builder, true);
    }

    private VespaServicesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for vespa-services must be initialized: " + builder.__uninitialized);
        }
        this.service = Service.createVector(builder.service);
    }

    public List<Service> service() {
        return this.service;
    }

    public Service service(int i) {
        return (Service)((Object)this.service.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(VespaServicesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Service
    extends InnerNode {
        private final StringNode configId;
        private final StringNode name;
        private final IntegerNode port;
        private final InnerNodeVector<Dimension> dimension;

        public Service(Builder builder) {
            this(builder, true);
        }

        private Service(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for vespa-services.service[] must be initialized: " + builder.__uninitialized);
            }
            this.configId = builder.configId == null ? new StringNode() : new StringNode(builder.configId);
            this.name = builder.name == null ? new StringNode(VespaServicesConfig.CONFIG_DEF_VERSION) : new StringNode(builder.name);
            this.port = builder.port == null ? new IntegerNode(-1) : new IntegerNode(builder.port.intValue());
            this.dimension = Dimension.createVector(builder.dimension);
        }

        public String configId() {
            return this.configId.value();
        }

        public String name() {
            return this.name.value();
        }

        public int port() {
            return this.port.value();
        }

        public List<Dimension> dimension() {
            return this.dimension;
        }

        public Dimension dimension(int i) {
            return (Dimension)((Object)this.dimension.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Service newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("service");
            return changes;
        }

        private static InnerNodeVector<Service> createVector(List<Builder> builders) {
            ArrayList<Service> elems = new ArrayList<Service>();
            for (Builder b : builders) {
                elems.add(new Service(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Dimension
        extends InnerNode {
            private final StringNode key;
            private final StringNode value;

            public Dimension(Builder builder) {
                this(builder, true);
            }

            private Dimension(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for vespa-services.service[].dimension[] must be initialized: " + builder.__uninitialized);
                }
                this.key = builder.key == null ? new StringNode() : new StringNode(builder.key);
                this.value = builder.value == null ? new StringNode() : new StringNode(builder.value);
            }

            public String key() {
                return this.key.value();
            }

            public String value() {
                return this.value.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Dimension newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("dimension");
                return changes;
            }

            private static InnerNodeVector<Dimension> createVector(List<Builder> builders) {
                ArrayList<Dimension> elems = new ArrayList<Dimension>();
                for (Builder b : builders) {
                    elems.add(new Dimension(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("key", "value"));
                private String key = null;
                private String value = null;

                public Builder() {
                }

                public Builder(Dimension config) {
                    this.key(config.key());
                    this.value(config.value());
                }

                private Builder override(Builder __superior) {
                    if (__superior.key != null) {
                        this.key(__superior.key);
                    }
                    if (__superior.value != null) {
                        this.value(__superior.value);
                    }
                    return this;
                }

                public Builder key(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.key = __value;
                    this.__uninitialized.remove("key");
                    return this;
                }

                public Builder value(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.value = __value;
                    this.__uninitialized.remove("value");
                    return this;
                }

                public Dimension build() {
                    return new Dimension(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("configId"));
            private String configId = null;
            private String name = null;
            private Integer port = null;
            public List<Dimension.Builder> dimension = new ArrayList<Dimension.Builder>();

            public Builder() {
            }

            public Builder(Service config) {
                this.configId(config.configId());
                this.name(config.name());
                this.port(config.port());
                for (Dimension d : config.dimension()) {
                    this.dimension(new Dimension.Builder(d));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.configId != null) {
                    this.configId(__superior.configId);
                }
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.port != null) {
                    this.port(__superior.port);
                }
                if (!__superior.dimension.isEmpty()) {
                    this.dimension.addAll(__superior.dimension);
                }
                return this;
            }

            public Builder configId(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.configId = __value;
                this.__uninitialized.remove("configId");
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                return this;
            }

            public Builder port(int __value) {
                this.port = __value;
                return this;
            }

            private Builder port(String __value) {
                return this.port(Integer.valueOf(__value));
            }

            public Builder dimension(Dimension.Builder __builder) {
                this.dimension.add(__builder);
                return this;
            }

            public Builder dimension(Consumer<Dimension.Builder> __func) {
                Dimension.Builder __inner = new Dimension.Builder();
                __func.accept(__inner);
                this.dimension.add(__inner);
                return this;
            }

            public Builder dimension(List<Dimension.Builder> __builders) {
                this.dimension = __builders;
                return this;
            }

            public Service build() {
                return new Service(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Service.Builder> service = new ArrayList<Service.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(VespaServicesConfig config) {
            for (Service s : config.service()) {
                this.service(new Service.Builder(s));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.service.isEmpty()) {
                this.service.addAll(__superior.service);
            }
            return this;
        }

        public Builder service(Service.Builder __builder) {
            this.service.add(__builder);
            return this;
        }

        public Builder service(Consumer<Service.Builder> __func) {
            Service.Builder __inner = new Service.Builder();
            __func.accept(__inner);
            this.service.add(__inner);
            return this;
        }

        public Builder service(List<Service.Builder> __builders) {
            this.service = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return VespaServicesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return VespaServicesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return VespaServicesConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public VespaServicesConfig build() {
            return new VespaServicesConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

