/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.metric.HealthMetric;
import ai.vespa.metricsproxy.service.HttpMetricFetcher;
import ai.vespa.metricsproxy.service.VespaService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteHealthMetricFetcher
extends HttpMetricFetcher {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final Logger log = Logger.getLogger(RemoteHealthMetricFetcher.class.getPackage().getName());
    private static final String HEALTH_PATH = "/state/v1/health";

    public RemoteHealthMetricFetcher(VespaService service, int port) {
        super(service, port, HEALTH_PATH);
    }

    public HealthMetric getHealth(int fetchCount) {
        HealthMetric healthMetric;
        block8: {
            InputStream stream = this.getJson();
            try {
                healthMetric = this.createHealthMetrics(stream, fetchCount);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    this.logMessageNoResponse(this.errMsgNoResponse(e), fetchCount);
                    return HealthMetric.getUnknown("Failed fetching metrics for service: " + this.service.getMonitoringName());
                }
            }
            stream.close();
        }
        return healthMetric;
    }

    private HealthMetric createHealthMetrics(InputStream data, int fetchCount) throws IOException {
        try {
            return this.parse(data);
        }
        catch (Exception e) {
            this.handleException(e, data, fetchCount);
            while (data.read() != -1) {
            }
            return HealthMetric.getDown("Failed fetching status page for service");
        }
    }

    private HealthMetric parse(InputStream data) {
        try {
            JsonNode o = jsonMapper.readTree(data);
            JsonNode status = o.get("status");
            String code = status.get("code").asText();
            String message = "";
            if (status.has("message")) {
                message = status.get("message").textValue();
            }
            return HealthMetric.get(code, message);
        }
        catch (IOException e) {
            log.log(Level.FINE, () -> "Failed to parse json response from metrics page:" + e + ":" + data);
            return HealthMetric.getUnknown("Not able to parse json from status page");
        }
    }
}

