/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.core;

import ai.vespa.metricsproxy.core.ConfiguredMetric;
import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.metric.AggregationKey;
import ai.vespa.metricsproxy.metric.HealthMetric;
import ai.vespa.metricsproxy.metric.Metric;
import ai.vespa.metricsproxy.metric.Metrics;
import ai.vespa.metricsproxy.metric.MetricsFormatter;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.Dimension;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.service.MetricsParser;
import ai.vespa.metricsproxy.service.VespaService;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class VespaMetrics {
    public static final ConsumerId vespaMetricsConsumerId = ConsumerId.toConsumerId("Vespa");
    public static final DimensionId METRIC_TYPE_DIMENSION_ID = DimensionId.toDimensionId("metrictype");
    public static final DimensionId INSTANCE_DIMENSION_ID = DimensionId.toDimensionId("instance");
    private final MetricsConsumers metricsConsumers;
    private static final MetricsFormatter formatter = new MetricsFormatter(false, false);

    public VespaMetrics(MetricsConsumers metricsConsumers) {
        this.metricsConsumers = metricsConsumers;
    }

    public List<MetricsPacket> getHealthMetrics(List<VespaService> services) {
        ArrayList<MetricsPacket> result = new ArrayList<MetricsPacket>();
        for (VespaService s : services) {
            HealthMetric h = s.getHealth();
            MetricsPacket.Builder builder = new MetricsPacket.Builder(s.getMonitoringName()).statusCode(h.isOk() ? 0 : 1).statusMessage(h.getMessage()).putDimension(METRIC_TYPE_DIMENSION_ID, "health").putDimension(INSTANCE_DIMENSION_ID, s.getInstanceName());
            result.add(builder.build());
        }
        return result;
    }

    public List<MetricsPacket.Builder> getMetrics(List<VespaService> services, ConsumerId consumerId) {
        ArrayList<MetricsPacket.Builder> metricsPackets = new ArrayList<MetricsPacket.Builder>();
        for (VespaService service : services) {
            Optional<MetricsPacket.Builder> systemCheck = this.getSystemMetrics(service);
            systemCheck.ifPresent(metricsPackets::add);
            MetricAggregator aggregator = new MetricAggregator(service.getDimensions());
            GetServiceMetricsConsumerBase metricsConsumer = consumerId != null ? new GetServiceMetricsConsumer(this.metricsConsumers, aggregator, consumerId) : new GetServiceMetricsConsumerForAll(this.metricsConsumers, aggregator);
            service.consumeMetrics(metricsConsumer);
            if (!aggregator.getAggregated().isEmpty()) {
                aggregator.getAggregated().forEach((aggregationKey, metrics) -> {
                    MetricsPacket.Builder builder = new MetricsPacket.Builder(service.getMonitoringName()).putMetrics((Collection<Metric>)metrics).putDimension(METRIC_TYPE_DIMENSION_ID, "standard").putDimension(INSTANCE_DIMENSION_ID, service.getInstanceName()).putDimensions(aggregationKey.getDimensions());
                    VespaMetrics.setMetaInfo(builder, ((Metric)metrics.get(0)).getTimeStamp());
                    builder.addConsumers(aggregationKey.getConsumers());
                    metricsPackets.add(builder);
                });
                continue;
            }
            metricsPackets.add(this.getHealth(service));
        }
        return metricsPackets;
    }

    private MetricsPacket.Builder getHealth(VespaService service) {
        HealthMetric health = service.getHealth();
        return new MetricsPacket.Builder(service.getMonitoringName()).timestamp(System.currentTimeMillis() / 1000L).statusCode(health.getStatus().ordinal()).statusMessage(health.getMessage()).putDimensions(service.getDimensions()).putDimension(INSTANCE_DIMENSION_ID, service.getInstanceName()).addConsumers(this.metricsConsumers.getAllConsumers());
    }

    private Optional<MetricsPacket.Builder> getSystemMetrics(VespaService service) {
        Metrics systemMetrics = service.getSystemMetrics();
        if (systemMetrics.size() == 0) {
            return Optional.empty();
        }
        MetricsPacket.Builder builder = new MetricsPacket.Builder(service.getMonitoringName());
        VespaMetrics.setMetaInfo(builder, systemMetrics.getTimeStamp());
        builder.putDimension(METRIC_TYPE_DIMENSION_ID, "system").putDimension(INSTANCE_DIMENSION_ID, service.getInstanceName()).putDimensions(service.getDimensions()).putMetrics(systemMetrics.list());
        builder.addConsumers(this.metricsConsumers.getAllConsumers());
        return Optional.of(builder);
    }

    private List<ConfiguredMetric> getMetricDefinitions(ConsumerId consumer) {
        if (this.metricsConsumers == null) {
            return Collections.emptyList();
        }
        List<ConfiguredMetric> definitions = this.metricsConsumers.getMetricDefinitions(consumer);
        return definitions == null ? Collections.emptyList() : definitions;
    }

    private static void setMetaInfo(MetricsPacket.Builder builder, Instant timestamp) {
        builder.timestamp(timestamp.getEpochSecond()).statusCode(0).statusMessage("Data collected successfully");
    }

    public String getMetricsAsString(List<VespaService> services) {
        MetricStringBuilder msb = new MetricStringBuilder();
        Iterator<VespaService> iterator = services.iterator();
        while (iterator.hasNext()) {
            VespaService service;
            msb.service = service = iterator.next();
            service.consumeMetrics(msb);
        }
        return msb.toString();
    }

    public String getMetricNames(List<VespaService> services, ConsumerId consumer) {
        MetricNamesBuilder metricNamesBuilder = new MetricNamesBuilder(consumer);
        for (VespaService service : services) {
            service.consumeMetrics(metricNamesBuilder);
        }
        return metricNamesBuilder.toString();
    }

    private class MetricNamesBuilder
    implements MetricsParser.Consumer {
        private final StringBuilder bufferOn = new StringBuilder();
        private final StringBuilder bufferOff = new StringBuilder();
        private final ConsumerId consumer;

        MetricNamesBuilder(ConsumerId consumer) {
            this.consumer = consumer;
        }

        @Override
        public void consume(Metric m) {
            String description = m.getDescription();
            MetricId alias = MetricId.empty;
            boolean isForwarded = false;
            for (ConfiguredMetric metric : VespaMetrics.this.getMetricDefinitions(this.consumer)) {
                if (!metric.id().equals(m.getName())) continue;
                alias = metric.outputname();
                isForwarded = true;
                if (!description.isEmpty()) continue;
                description = metric.description();
            }
            String message = "OFF";
            StringBuilder buffer = this.bufferOff;
            if (isForwarded) {
                buffer = this.bufferOn;
                message = "ON";
            }
            buffer.append(m.getName()).append('=').append(message);
            if (!description.isEmpty()) {
                buffer.append(";description=").append(description);
            }
            if (!alias.id.isEmpty()) {
                buffer.append(";output-name=").append(alias);
            }
            buffer.append(',');
        }

        public String toString() {
            return this.bufferOn.append((CharSequence)this.bufferOff).toString();
        }
    }

    private class MetricStringBuilder
    implements MetricsParser.Consumer {
        private final StringBuilder sb = new StringBuilder();
        private VespaService service;

        private MetricStringBuilder() {
        }

        @Override
        public void consume(Metric metric) {
            MetricId key;
            MetricId alias = key = metric.getName();
            boolean isForwarded = false;
            for (ConfiguredMetric metricConsumer : VespaMetrics.this.getMetricDefinitions(vespaMetricsConsumerId)) {
                if (!metricConsumer.id().equals(key)) continue;
                alias = metricConsumer.outputname();
                isForwarded = true;
            }
            if (isForwarded) {
                this.sb.append(formatter.format(this.service, alias.id, metric.getValue())).append(" ");
            }
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    private static class MetricAggregator {
        private final Map<AggregationKey, List<Metric>> aggregated = new HashMap<AggregationKey, List<Metric>>();
        private final Map<DimensionId, String> serviceDimensions;

        MetricAggregator(Map<DimensionId, String> serviceDimensions) {
            this.serviceDimensions = serviceDimensions;
        }

        Map<AggregationKey, List<Metric>> getAggregated() {
            return this.aggregated;
        }

        void aggregate(Metric metric) {
            LinkedHashMap<DimensionId, String> mergedDimensions = new LinkedHashMap<DimensionId, String>();
            mergedDimensions.putAll(metric.getDimensions());
            mergedDimensions.putAll(this.serviceDimensions);
            AggregationKey aggregationKey = new AggregationKey(mergedDimensions, metric.getConsumers());
            this.aggregated.computeIfAbsent(aggregationKey, key -> new ArrayList()).add(metric);
        }
    }

    private static class GetServiceMetricsConsumerForAll
    extends GetServiceMetricsConsumerBase {
        private final MetricsConsumers metricsConsumers;

        GetServiceMetricsConsumerForAll(MetricsConsumers metricsConsumers, MetricAggregator aggregator) {
            super(aggregator);
            this.metricsConsumers = metricsConsumers;
        }

        @Override
        public void consume(Metric candidate) {
            Map<ConfiguredMetric, Set<ConsumerId>> consumersByMetric = this.metricsConsumers.getConsumersByMetric(candidate.getName());
            if (consumersByMetric != null) {
                consumersByMetric.keySet().forEach(configuredMetric -> this.aggregator.aggregate(GetServiceMetricsConsumerForAll.metricWithConfigProperties(candidate, configuredMetric, (Set)consumersByMetric.get(configuredMetric))));
            }
        }
    }

    private static class GetServiceMetricsConsumer
    extends GetServiceMetricsConsumerBase {
        private final Map<MetricId, ConfiguredMetric> configuredMetrics;
        private final Set<ConsumerId> consumerId;

        GetServiceMetricsConsumer(MetricsConsumers metricsConsumers, MetricAggregator aggregator, ConsumerId consumerId) {
            super(aggregator);
            this.consumerId = Set.of(consumerId);
            this.configuredMetrics = metricsConsumers.getMetricsForConsumer(consumerId);
        }

        @Override
        public void consume(Metric candidate) {
            ConfiguredMetric configuredMetric = this.configuredMetrics.get(candidate.getName());
            if (configuredMetric != null) {
                this.aggregator.aggregate(GetServiceMetricsConsumer.metricWithConfigProperties(candidate, configuredMetric, this.consumerId));
            }
        }
    }

    private static abstract class GetServiceMetricsConsumerBase
    implements MetricsParser.Consumer {
        protected final MetricAggregator aggregator;

        GetServiceMetricsConsumerBase(MetricAggregator aggregator) {
            this.aggregator = aggregator;
        }

        protected static Metric metricWithConfigProperties(Metric candidate, ConfiguredMetric configuredMetric, Set<ConsumerId> consumers) {
            Metric metric = candidate.clone();
            metric.setDimensions(GetServiceMetricsConsumerBase.extractDimensions(candidate.getDimensions(), configuredMetric.dimension()));
            metric.setConsumers(GetServiceMetricsConsumerBase.extractConsumers(consumers));
            if (configuredMetric.outputname() != null && !configuredMetric.outputname().id.isEmpty()) {
                metric.setName(configuredMetric.outputname());
            }
            return metric;
        }

        private static Map<DimensionId, String> extractDimensions(Map<DimensionId, String> dimensions, List<Dimension> configuredDimensions) {
            if (!configuredDimensions.isEmpty()) {
                HashMap<DimensionId, String> dims = new HashMap<DimensionId, String>(dimensions);
                configuredDimensions.forEach(d -> dims.put(d.key(), d.value()));
                dimensions = Collections.unmodifiableMap(dims);
            }
            return dimensions;
        }

        private static Set<ConsumerId> extractConsumers(Set<ConsumerId> configuredConsumers) {
            return configuredConsumers != null ? configuredConsumers : Set.of();
        }
    }
}

