/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model.json;

import ai.vespa.metricsproxy.metric.model.json.YamasJsonModel;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class YamasArrayJsonModel {
    @JsonProperty(value="metrics")
    public final List<YamasJsonModel> metrics = new ArrayList<YamasJsonModel>();

    public void add(List<YamasJsonModel> results) {
        this.metrics.addAll(results);
    }

    public void add(YamasJsonModel result) {
        this.metrics.add(result);
    }

    public void add(YamasArrayJsonModel array) {
        this.metrics.addAll(array.metrics);
    }

    public String serialize() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("DoubleSerializer", new Version(1, 0, 0, "", null, null));
        module.addSerializer(Double.class, (JsonSerializer)new DoubleSerializer());
        mapper.registerModule((Module)module);
        if (this.metrics.size() > 0) {
            try {
                return mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        return "{}";
    }

    public class DoubleSerializer
    extends JsonSerializer<Double> {
        public void serialize(Double value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            DecimalFormat df = new DecimalFormat("#.####", new DecimalFormatSymbols(Locale.ENGLISH));
            df.setMaximumFractionDigits(13);
            jgen.writeNumber(df.format(value));
        }
    }
}

