/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model.json;

import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.ServiceId;
import ai.vespa.metricsproxy.metric.model.json.YamasArrayJsonModel;
import ai.vespa.metricsproxy.metric.model.json.YamasJsonModel;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.yahoo.stream.CustomCollectors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class JsonUtil {
    private static final Logger log = Logger.getLogger(JsonUtil.class.getName());
    static final String YAMAS_ROUTING = "yamas";

    public static MetricsPacket.Builder toMetricsPacketBuilder(YamasJsonModel jsonModel) {
        if (jsonModel.application == null) {
            throw new IllegalArgumentException("Service id cannot be null");
        }
        return new MetricsPacket.Builder(ServiceId.toServiceId(jsonModel.application)).statusCode(jsonModel.status_code).statusMessage(jsonModel.status_msg).timestamp(jsonModel.timestamp).putMetrics(jsonModel.getMetricsList()).putDimensions(jsonModel.getDimensionsById()).addConsumers(jsonModel.getYamasConsumers());
    }

    public static YamasArrayJsonModel toYamasArray(Collection<MetricsPacket> metricsPackets) {
        YamasArrayJsonModel yamasArray = JsonUtil.toYamasArray(metricsPackets, false);
        yamasArray.metrics.stream().findFirst().map(YamasJsonModel::getYamasConsumers).ifPresent(consumers -> yamasArray.add(JsonUtil.getStatusYamasModel("Data collected successfully", 0, consumers)));
        return yamasArray;
    }

    public static YamasArrayJsonModel toYamasArray(Collection<MetricsPacket> metricsPackets, boolean addStatus) {
        YamasArrayJsonModel yamasArray = new YamasArrayJsonModel();
        metricsPackets.forEach(packet -> yamasArray.add(JsonUtil.toYamasModel(packet, addStatus)));
        return yamasArray;
    }

    public static List<MetricsPacket.Builder> toMetricsPackets(String jsonString) {
        ArrayList<MetricsPacket.Builder> packets = new ArrayList<MetricsPacket.Builder>();
        try {
            JsonParser jp = new JsonFactory().createParser(jsonString);
            jp.setCodec((ObjectCodec)new ObjectMapper());
            while (jp.nextToken() != null) {
                YamasJsonModel jsonModel = (YamasJsonModel)jp.readValueAs(YamasJsonModel.class);
                packets.add(JsonUtil.toMetricsPacketBuilder(jsonModel));
            }
            return packets;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not create metrics packet from string:\n" + jsonString, e);
            return Collections.emptyList();
        }
    }

    private static YamasJsonModel getStatusYamasModel(String statusMessage, int statusCode, Collection<ConsumerId> consumers) {
        YamasJsonModel model = new YamasJsonModel();
        model.status_code = statusCode;
        model.status_msg = statusMessage;
        model.application = "yms_check_vespa";
        model.routing = ImmutableMap.of((Object)YAMAS_ROUTING, (Object)JsonUtil.toYamasJsonNamespaces(consumers));
        return model;
    }

    private static YamasJsonModel toYamasModel(MetricsPacket packet, boolean addStatus) {
        YamasJsonModel model = new YamasJsonModel();
        if (addStatus) {
            model.status_code = packet.statusCode;
            model.status_msg = packet.statusMessage;
        }
        model.application = packet.service.id;
        model.timestamp = packet.timestamp == 0L ? null : Long.valueOf(packet.timestamp);
        model.metrics = packet.metrics().isEmpty() ? null : (Map)packet.metrics().entrySet().stream().collect(CustomCollectors.toLinkedMap(id2metric -> ((MetricId)id2metric.getKey()).id, id2metric -> ((Number)id2metric.getValue()).doubleValue()));
        model.dimensions = packet.dimensions().isEmpty() ? null : (Map)packet.dimensions().entrySet().stream().collect(CustomCollectors.toLinkedMap(id2dim -> ((DimensionId)id2dim.getKey()).id, Map.Entry::getValue));
        model.routing = packet.consumers().isEmpty() ? null : ImmutableMap.of((Object)YAMAS_ROUTING, (Object)JsonUtil.toYamasJsonNamespaces(packet.consumers()));
        return model;
    }

    private static YamasJsonModel.YamasJsonNamespace toYamasJsonNamespaces(Collection<ConsumerId> consumers) {
        YamasJsonModel.YamasJsonNamespace namespaces = new YamasJsonModel.YamasJsonNamespace();
        namespaces.namespaces = consumers.stream().map(consumer -> consumer.id).collect(Collectors.toList());
        return namespaces;
    }
}

