/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric;

import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Metric {
    private final long time;
    private final Number value;
    private final String description;
    private MetricId name;
    private Map<DimensionId, String> dimensions;
    private Set<ConsumerId> consumers;

    public Metric(MetricId name, Number value, long time, Map<DimensionId, String> dimensions, String description) {
        this.time = time;
        this.value = value;
        this.name = name;
        this.dimensions = dimensions;
        this.description = description;
    }

    public Metric(MetricId name, Number value, long timestamp) {
        this(name, value, timestamp, Collections.emptyMap(), "");
    }

    public Metric(MetricId name, Number value) {
        this(name, value, System.currentTimeMillis() / 1000L);
    }

    public void setDimensions(Map<DimensionId, String> dimensions) {
        this.dimensions = dimensions;
    }

    public Map<DimensionId, String> getDimensions() {
        return this.dimensions;
    }

    public void setConsumers(Set<ConsumerId> consumers) {
        this.consumers = consumers;
    }

    public Set<ConsumerId> getConsumers() {
        return this.consumers;
    }

    public Number getValue() {
        return this.value;
    }

    public void setName(MetricId name) {
        this.name = name;
    }

    public MetricId getName() {
        return this.name;
    }

    public long getTimeStamp() {
        return this.time;
    }

    public String toString() {
        return "Metric{time=" + this.time + ", name=" + this.name.id + ", value='" + this.value + "', dimensions=" + this.dimensions + "}";
    }

    public Metric clone() {
        return new Metric(this.name, this.value, this.time, new LinkedHashMap<DimensionId, String>(this.dimensions), this.getDescription());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Metric)) {
            return false;
        }
        Metric rhs = (Metric)obj;
        return this.name.equals(rhs.name) && this.description.equals(rhs.description) && this.value.equals(rhs.value) && this.time == rhs.time && Objects.equals(this.dimensions, rhs.dimensions) && Objects.equals(this.consumers, rhs.consumers);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.value, this.dimensions, this.consumers, this.time);
    }

    public String getDescription() {
        return this.description;
    }

    public static long adjustTime(long timestamp, long now) {
        if (now == timestamp + 1L && now % 60L == 0L) {
            return now;
        }
        return timestamp;
    }
}

