/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.metric.Metric;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MetricsParser {
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    static void parse(String data, Consumer consumer) throws IOException {
        MetricsParser.parse(jsonMapper.createParser(data), consumer);
    }

    static void parse(InputStream data, Consumer consumer) throws IOException {
        MetricsParser.parse(jsonMapper.createParser(data), consumer);
    }

    private static void parse(JsonParser parser, Consumer consumer) throws IOException {
        if (parser.nextToken() != JsonToken.START_OBJECT) {
            throw new IOException("Expected start of object, got " + parser.currentToken());
        }
        parser.nextToken();
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            JsonToken token = parser.nextToken();
            if (fieldName.equals("metrics")) {
                MetricsParser.parseMetrics(parser, consumer);
            } else if (token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY) {
                parser.skipChildren();
            }
            parser.nextToken();
        }
    }

    private static long secondsSince1970UTC() {
        return System.currentTimeMillis() / 1000L;
    }

    private static long parseSnapshot(JsonParser parser) throws IOException {
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new IOException("Expected start of 'snapshot' object, got " + parser.currentToken());
        }
        long timestamp = MetricsParser.secondsSince1970UTC();
        parser.nextToken();
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            JsonToken token = parser.nextToken();
            if (fieldName.equals("to")) {
                timestamp = parser.getLongValue();
                long now = System.currentTimeMillis() / 1000L;
                timestamp = Metric.adjustTime(timestamp, now);
            } else if (token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY) {
                parser.skipChildren();
            }
            parser.nextToken();
        }
        return timestamp;
    }

    private static void parseValues(JsonParser parser, long timestamp, Consumer consumer) throws IOException {
        if (parser.getCurrentToken() != JsonToken.START_ARRAY) {
            throw new IOException("Expected start of 'metrics:values' array, got " + parser.currentToken());
        }
        HashMap<String, Map<DimensionId, String>> uniqueDimensions = new HashMap<String, Map<DimensionId, String>>();
        while (parser.nextToken() == JsonToken.START_OBJECT) {
            JsonNode value = (JsonNode)jsonMapper.readTree(parser);
            MetricsParser.handleValue(value, timestamp, consumer, uniqueDimensions);
        }
    }

    private static void parseMetrics(JsonParser parser, Consumer consumer) throws IOException {
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new IOException("Expected start of 'metrics' object, got " + parser.currentToken());
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        parser.nextToken();
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            JsonToken token = parser.nextToken();
            if (fieldName.equals("snapshot")) {
                timestamp = MetricsParser.parseSnapshot(parser);
            } else if (fieldName.equals("values")) {
                MetricsParser.parseValues(parser, timestamp, consumer);
            } else if (token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY) {
                parser.skipChildren();
            }
            parser.nextToken();
        }
    }

    private static void handleValue(JsonNode metric, long timestamp, Consumer consumer, Map<String, Map<DimensionId, String>> uniqueDimensions) {
        String name = metric.get("name").textValue();
        String description = "";
        if (metric.has("description")) {
            description = metric.get("description").textValue();
        }
        Map<Object, Object> dim = Collections.emptyMap();
        if (metric.has("dimensions")) {
            String v;
            String k;
            JsonNode dimensions = metric.get("dimensions");
            StringBuilder sb = new StringBuilder();
            Iterator it = dimensions.fieldNames();
            while (it.hasNext()) {
                k = (String)it.next();
                v = dimensions.get(k).asText();
                sb.append(DimensionId.toDimensionId(k)).append(v);
            }
            if (!uniqueDimensions.containsKey(sb.toString())) {
                dim = new HashMap();
                it = dimensions.fieldNames();
                while (it.hasNext()) {
                    k = (String)it.next();
                    v = dimensions.get(k).textValue();
                    dim.put(DimensionId.toDimensionId(k), v);
                }
                uniqueDimensions.put(sb.toString(), Collections.unmodifiableMap(dim));
            }
            dim = uniqueDimensions.get(sb.toString());
        }
        JsonNode aggregates = metric.get("values");
        Iterator it = aggregates.fieldNames();
        while (it.hasNext()) {
            String aggregator = (String)it.next();
            JsonNode aggregatorValue = aggregates.get(aggregator);
            if (aggregatorValue == null) {
                throw new IllegalArgumentException("Value for aggregator '" + aggregator + "' is missing");
            }
            Number value = aggregatorValue.numberValue();
            if (value == null) {
                throw new IllegalArgumentException("Value for aggregator '" + aggregator + "' is not a number");
            }
            String metricName = name + "." + aggregator;
            consumer.consume(new Metric(MetricId.toMetricId(metricName), value, timestamp, dim, description));
        }
    }

    public static interface Consumer {
        public void consume(Metric var1);
    }
}

