/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http.prometheus;

import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.core.MetricsManager;
import ai.vespa.metricsproxy.http.TextResponse;
import ai.vespa.metricsproxy.http.ValuesFetcher;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.prometheus.PrometheusUtil;
import ai.vespa.metricsproxy.service.VespaServices;
import com.google.inject.Inject;
import com.yahoo.container.handler.metrics.HttpHandlerBase;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.restapi.Path;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public class PrometheusHandler
extends HttpHandlerBase {
    public static final String V1_PATH = "/prometheus/v1";
    static final String VALUES_PATH = "/prometheus/v1/values";
    private final ValuesFetcher valuesFetcher;

    @Inject
    public PrometheusHandler(Executor executor, MetricsManager metricsManager, VespaServices vespaServices, MetricsConsumers metricsConsumers) {
        super(executor);
        this.valuesFetcher = new ValuesFetcher(metricsManager, vespaServices, metricsConsumers);
    }

    public Optional<HttpResponse> doHandle(URI requestUri, Path apiPath, String consumer) {
        if (apiPath.matches(V1_PATH)) {
            return Optional.of(this.resourceListResponse(requestUri, List.of(VALUES_PATH)));
        }
        if (apiPath.matches(VALUES_PATH)) {
            return Optional.of(this.valuesResponse(consumer));
        }
        return Optional.empty();
    }

    private TextResponse valuesResponse(String consumer) {
        try {
            List<MetricsPacket> metrics = this.valuesFetcher.fetch(consumer);
            return new TextResponse(200, PrometheusUtil.toPrometheusModel(metrics).serialize());
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Got exception when rendering metrics:", e);
            return new TextResponse(500, e.getMessage());
        }
    }
}

