/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http.application;

import ai.vespa.metricsproxy.http.application.ClusterIdDimensionProcessor;
import ai.vespa.metricsproxy.http.application.Node;
import ai.vespa.metricsproxy.http.application.PublicDimensionsProcessor;
import ai.vespa.metricsproxy.http.application.ServiceIdDimensionProcessor;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.json.GenericJsonUtil;
import ai.vespa.metricsproxy.metric.model.processing.MetricsProcessor;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public class NodeMetricsClient {
    private static final Logger log = Logger.getLogger(NodeMetricsClient.class.getName());
    static final Duration METRICS_TTL = Duration.ofSeconds(30L);
    private static final int MAX_DIMENSIONS = 10;
    final Node node;
    private final HttpClient httpClient;
    private final Clock clock;
    private final Map<ConsumerId, Snapshot> snapshots = new ConcurrentHashMap<ConsumerId, Snapshot>();
    private long snapshotsRetrieved = 0L;

    NodeMetricsClient(HttpClient httpClient, Node node, Clock clock) {
        this.httpClient = httpClient;
        this.node = node;
        this.clock = clock;
    }

    public List<MetricsPacket> getMetrics(ConsumerId consumer) {
        Snapshot currentSnapshot = this.snapshots.get(consumer);
        if (currentSnapshot == null || currentSnapshot.isStale(this.clock) || currentSnapshot.metrics.isEmpty()) {
            Snapshot snapshot = this.retrieveMetrics(consumer);
            this.snapshots.put(consumer, snapshot);
            return snapshot.metrics;
        }
        return this.snapshots.get((Object)consumer).metrics;
    }

    private Snapshot retrieveMetrics(ConsumerId consumer) {
        String metricsUri = this.node.metricsUri(consumer).toString();
        log.log(Level.FINE, () -> "Retrieving metrics from host " + metricsUri);
        try {
            String metricsJson = (String)this.httpClient.execute((ClassicHttpRequest)new HttpGet(metricsUri), (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
            List<MetricsPacket.Builder> metricsBuilders = GenericJsonUtil.toMetricsPackets(metricsJson);
            List<MetricsPacket> metrics = NodeMetricsClient.processAndBuild(metricsBuilders, new ServiceIdDimensionProcessor(), new ClusterIdDimensionProcessor(), new PublicDimensionsProcessor(10));
            ++this.snapshotsRetrieved;
            log.log(Level.FINE, () -> "Successfully retrieved " + metrics.size() + " metrics packets from " + metricsUri);
            return new Snapshot(Instant.now(this.clock), metrics);
        }
        catch (IOException e) {
            log.warning("Unable to retrieve metrics from " + metricsUri + ": " + Exceptions.toMessageString((Throwable)e));
            return new Snapshot(Instant.now(this.clock), Collections.emptyList());
        }
    }

    private static List<MetricsPacket> processAndBuild(List<MetricsPacket.Builder> builders, MetricsProcessor ... processors) {
        return builders.stream().map(builder -> MetricsProcessor.applyProcessors(builder, processors)).map(MetricsPacket.Builder::build).collect(Collectors.toList());
    }

    long snapshotsRetrieved() {
        return this.snapshotsRetrieved;
    }

    static class Snapshot {
        final Instant timestamp;
        final List<MetricsPacket> metrics;

        Snapshot(Instant timestamp, List<MetricsPacket> metrics) {
            this.timestamp = timestamp;
            this.metrics = metrics;
        }

        boolean isStale(Clock clock) {
            return Instant.now(clock).isAfter(this.timestamp.plus(METRICS_TTL));
        }
    }
}

