/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.service.VespaService;
import ai.vespa.util.http.hc5.VespaAsyncHttpClientBuilder;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.http.nio.support.BasicResponseConsumer;
import org.apache.hc.core5.http.nio.support.classic.AbstractClassicEntityConsumer;
import org.apache.hc.core5.util.Timeout;

public abstract class HttpMetricFetcher {
    private static final Logger log = Logger.getLogger(HttpMetricFetcher.class.getPackage().getName());
    public static final String STATE_PATH = "/state/v1/";
    public static int CONNECTION_TIMEOUT = 5000;
    private static final int SOCKET_TIMEOUT = 60000;
    private static final int BUFFER_SIZE = 262144;
    private final URI url;
    protected final VespaService service;
    private static final CloseableHttpAsyncClient httpClient = HttpMetricFetcher.createHttpClient();

    HttpMetricFetcher(VespaService service, int port, String path) {
        this.service = service;
        String u = "http://localhost:" + port + path;
        this.url = URI.create(u);
        log.log(Level.FINE, "Fetching metrics from " + u + " with timeout " + CONNECTION_TIMEOUT);
    }

    InputStream getJson() throws IOException, InterruptedException, ExecutionException {
        log.log(Level.FINE, "Connecting to url " + this.url + " for service '" + this.service + "'");
        Future response = httpClient.execute((AsyncRequestProducer)new BasicRequestProducer(Method.GET, this.url), (AsyncResponseConsumer)new BasicResponseConsumer((AsyncEntityConsumer)new AbstractClassicEntityConsumer<InputStream>(262144, Runnable::run){

            protected InputStream consumeData(ContentType contentType, InputStream inputStream) {
                return inputStream;
            }
        }), null);
        return (InputStream)((Message)response.get()).getBody();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " using " + this.url;
    }

    String errMsgNoResponse(Exception e) {
        return "Unable to get response from service '" + this.service + "': " + Exceptions.toMessageString((Throwable)e);
    }

    void handleException(Exception e, Object data, int timesFetched) {
        this.logMessage("Unable to parse json '" + data + "' for service '" + this.service + "': " + Exceptions.toMessageString((Throwable)e), timesFetched);
    }

    private void logMessage(String message, int timesFetched) {
        if (this.service.isAlive() && timesFetched > 5) {
            log.log(Level.INFO, message);
        } else {
            log.log(Level.FINE, message);
        }
    }

    void logMessageNoResponse(String message, int timesFetched) {
        if (timesFetched > 5) {
            log.log(Level.WARNING, message);
        } else {
            log.log(Level.INFO, message);
        }
    }

    private static CloseableHttpAsyncClient createHttpClient() {
        CloseableHttpAsyncClient client = VespaAsyncHttpClientBuilder.create().setUserAgent("metrics-proxy-http-client").setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)CONNECTION_TIMEOUT)).setResponseTimeout(Timeout.ofMilliseconds((long)60000L)).build()).build();
        client.start();
        return client;
    }
}

