/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.metric.HealthMetric;
import ai.vespa.metricsproxy.service.HttpMetricFetcher;
import ai.vespa.metricsproxy.service.VespaService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteHealthMetricFetcher
extends HttpMetricFetcher {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final Logger log = Logger.getLogger(RemoteHealthMetricFetcher.class.getPackage().getName());
    private static final String HEALTH_PATH = "/state/v1/health";

    public RemoteHealthMetricFetcher(VespaService service, int port) {
        super(service, port, HEALTH_PATH);
    }

    public HealthMetric getHealth(int fetchCount) {
        String data = "{}";
        try {
            data = this.getJson();
        }
        catch (IOException e) {
            this.logMessageNoResponse(this.errMsgNoResponse(e), fetchCount);
        }
        return this.createHealthMetrics(data, fetchCount);
    }

    private HealthMetric createHealthMetrics(String data, int fetchCount) {
        HealthMetric healthMetric = HealthMetric.getDown("Failed fetching status page for service");
        try {
            healthMetric = this.parse(data);
        }
        catch (Exception e) {
            this.handleException(e, data, fetchCount);
        }
        return healthMetric;
    }

    private HealthMetric parse(String data) {
        if (data == null || data.isEmpty()) {
            return HealthMetric.getUnknown("Empty response from status page");
        }
        try {
            JsonNode o = jsonMapper.readTree(data);
            JsonNode status = o.get("status");
            String code = status.get("code").asText();
            String message = "";
            if (status.has("message")) {
                message = status.get("message").textValue();
            }
            return HealthMetric.get(code, message);
        }
        catch (IOException e) {
            log.log(Level.FINE, "Failed to parse json response from metrics page:" + e + ":" + data);
            return HealthMetric.getUnknown("Not able to parse json from status page");
        }
    }
}

