/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http.application;

import ai.vespa.metricsproxy.http.ValuesFetcher;
import ai.vespa.metricsproxy.http.application.ApplicationMetricsException;
import ai.vespa.metricsproxy.http.application.MetricsNodesConfig;
import ai.vespa.metricsproxy.http.application.Node;
import ai.vespa.metricsproxy.http.application.NodeMetricsClient;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.util.http.hc4.VespaHttpClientBuilder;
import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import java.time.Clock;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ApplicationMetricsRetriever
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(ApplicationMetricsRetriever.class.getName());
    static final int MAX_THREADS = 20;
    static final Duration MIN_TIMEOUT = Duration.ofSeconds(60L);
    static final Duration MAX_TIMEOUT = Duration.ofSeconds(240L);
    private static final int HTTP_CONNECT_TIMEOUT = 5000;
    private static final int HTTP_SOCKET_TIMEOUT = 30000;
    private final HttpClient httpClient = ApplicationMetricsRetriever.createHttpClient();
    private final List<NodeMetricsClient> clients;
    private final ForkJoinPool forkJoinPool;
    private Duration taskTimeout;

    @Inject
    public ApplicationMetricsRetriever(MetricsNodesConfig nodesConfig) {
        this.clients = this.createNodeClients(nodesConfig);
        int numThreads = Math.min(this.clients.size(), 20);
        this.taskTimeout = ApplicationMetricsRetriever.timeout(this.clients.size(), numThreads);
        this.forkJoinPool = new ForkJoinPool(numThreads);
    }

    public void deconstruct() {
        this.forkJoinPool.shutdownNow();
        super.deconstruct();
    }

    public Map<Node, List<MetricsPacket>> getMetrics() {
        return this.getMetrics(ValuesFetcher.defaultMetricsConsumerId);
    }

    public Map<Node, List<MetricsPacket>> getMetrics(ConsumerId consumer) {
        log.log(Level.FINE, () -> "Retrieving metrics from " + this.clients.size() + " nodes.");
        Future forkJoinTask = this.forkJoinPool.submit(() -> this.clients.parallelStream().map(client -> this.getNodeMetrics((NodeMetricsClient)client, consumer)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        try {
            Map metricsByNode = (Map)((ForkJoinTask)forkJoinTask).get(this.taskTimeout.toMillis(), TimeUnit.MILLISECONDS);
            log.log(Level.FINE, () -> "Finished retrieving metrics from " + this.clients.size() + " nodes.");
            return metricsByNode;
        }
        catch (Exception e) {
            throw new ApplicationMetricsException("Failed retrieving metrics.", e);
        }
    }

    private Map.Entry<Node, List<MetricsPacket>> getNodeMetrics(NodeMetricsClient client, ConsumerId consumer) {
        try {
            return new AbstractMap.SimpleEntry<Node, List<MetricsPacket>>(client.node, client.getMetrics(consumer));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not retrieve metrics from " + client.node.metricsUri(consumer), e);
            return new AbstractMap.SimpleEntry<Node, List<MetricsPacket>>(client.node, Collections.emptyList());
        }
    }

    private List<NodeMetricsClient> createNodeClients(MetricsNodesConfig nodesConfig) {
        return nodesConfig.node().stream().map(Node::new).map(node -> new NodeMetricsClient(this.httpClient, (Node)node, Clock.systemUTC())).collect(Collectors.toList());
    }

    private static CloseableHttpClient createHttpClient() {
        return VespaHttpClientBuilder.create(PoolingHttpClientConnectionManager::new).setUserAgent("application-metrics-retriever").setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(30000).build()).build();
    }

    static Duration timeout(int clients, int numThreads) {
        Duration timeout = Duration.ofSeconds(Long.max(MIN_TIMEOUT.toSeconds(), 20 * clients / numThreads));
        return timeout.compareTo(MAX_TIMEOUT) > 0 ? MAX_TIMEOUT : timeout;
    }

    void setTaskTimeout(Duration taskTimeout) {
        this.taskTimeout = taskTimeout;
    }
}

