/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.metric.Metrics;
import ai.vespa.metricsproxy.service.HttpMetricFetcher;
import ai.vespa.metricsproxy.service.MetricsParser;
import ai.vespa.metricsproxy.service.VespaService;
import java.io.IOException;

public class RemoteMetricsFetcher
extends HttpMetricFetcher {
    static final String METRICS_PATH = "/state/v1/metrics";

    RemoteMetricsFetcher(VespaService service, int port) {
        super(service, port, METRICS_PATH);
    }

    public Metrics getMetrics(int fetchCount) {
        try {
            return this.createMetrics(this.getJson(), fetchCount);
        }
        catch (IOException e) {
            return new Metrics();
        }
    }

    Metrics createMetrics(String data, int fetchCount) {
        Metrics remoteMetrics = new Metrics();
        try {
            remoteMetrics = MetricsParser.parse(data);
        }
        catch (Exception e) {
            this.handleException(e, data, fetchCount);
        }
        return remoteMetrics;
    }
}

