/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.rpc;

import ai.vespa.metricsproxy.rpc.RpcConnectorConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RpcConnector
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(RpcConnector.class.getName());
    private final Supervisor supervisor;
    private final Acceptor acceptor;

    public RpcConnector(RpcConnectorConfig config) {
        this.supervisor = new Supervisor(new Transport("rpc-" + config.port())).useSmallBuffers();
        Spec spec = new Spec(config.port());
        try {
            this.acceptor = this.supervisor.listen(spec);
            log.log(Level.FINE, "Listening on " + spec.host() + ":" + this.acceptor.port());
        }
        catch (ListenFailedException e) {
            this.stop();
            log.log(Level.INFO, "Failed listening at " + spec.host() + ":" + spec.port());
            throw new RuntimeException("Could not listen at " + spec, e);
        }
    }

    public int port() {
        return this.acceptor.port();
    }

    public void addMethod(Method method) {
        this.supervisor.addMethod(method);
    }

    public void stop() {
        if (this.acceptor != null) {
            this.acceptor.shutdown().join();
        }
        if (this.supervisor != null) {
            this.supervisor.transport().shutdown().join();
        }
    }

    public void deconstruct() {
        this.stop();
        super.deconstruct();
    }
}

