/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class JacksonUtil {
    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("DoubleSerializer", new Version(1, 0, 0, "", null, null));
        module.addSerializer(Double.class, (JsonSerializer)new DoubleSerializer());
        mapper.registerModule((Module)module);
        return mapper;
    }

    public static class DoubleSerializer
    extends JsonSerializer<Double> {
        public void serialize(Double value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            DecimalFormat df = new DecimalFormat("#.####", new DecimalFormatSymbols(Locale.ENGLISH));
            df.setMaximumFractionDigits(13);
            jgen.writeNumber(df.format(value));
        }
    }
}

