/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http.application;

import ai.vespa.metricsproxy.http.application.Node;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.json.GenericJsonUtil;
import com.yahoo.log.LogLevel;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;

public class NodeMetricsClient {
    private static final Logger log = Logger.getLogger(NodeMetricsClient.class.getName());
    static final Duration METRICS_TTL = Duration.ofSeconds(30L);
    final Node node;
    private final HttpClient httpClient;
    private final Clock clock;
    private final Map<ConsumerId, Snapshot> snapshots = new ConcurrentHashMap<ConsumerId, Snapshot>();
    private long snapshotsRetrieved = 0L;

    NodeMetricsClient(HttpClient httpClient, Node node, Clock clock) {
        this.httpClient = httpClient;
        this.node = node;
        this.clock = clock;
    }

    public List<MetricsPacket.Builder> getMetrics(ConsumerId consumer) {
        Snapshot currentSnapshot = this.snapshots.get(consumer);
        if (currentSnapshot == null || currentSnapshot.isStale(this.clock) || currentSnapshot.metrics.isEmpty()) {
            Snapshot snapshot = this.retrieveMetrics(consumer);
            this.snapshots.put(consumer, snapshot);
            return snapshot.metrics;
        }
        return this.snapshots.get((Object)consumer).metrics;
    }

    private Snapshot retrieveMetrics(ConsumerId consumer) {
        String metricsUri = this.node.metricsUri(consumer).toString();
        log.log((Level)LogLevel.DEBUG, () -> "Retrieving metrics from host " + metricsUri);
        try {
            String metricsJson = (String)this.httpClient.execute((HttpUriRequest)new HttpGet(metricsUri), (ResponseHandler)new BasicResponseHandler());
            List<MetricsPacket.Builder> newMetrics = GenericJsonUtil.toMetricsPackets(metricsJson);
            ++this.snapshotsRetrieved;
            log.log((Level)LogLevel.DEBUG, () -> "Successfully retrieved " + newMetrics.size() + " metrics packets from " + metricsUri);
            return new Snapshot(Instant.now(this.clock), newMetrics);
        }
        catch (IOException e) {
            log.warning("Unable to retrieve metrics from " + metricsUri + ": " + Exceptions.toMessageString((Throwable)e));
            return new Snapshot(Instant.now(this.clock), Collections.emptyList());
        }
    }

    long snapshotsRetrieved() {
        return this.snapshotsRetrieved;
    }

    static class Snapshot {
        final Instant timestamp;
        final List<MetricsPacket.Builder> metrics;

        Snapshot(Instant timestamp, List<MetricsPacket.Builder> metrics) {
            this.timestamp = timestamp;
            this.metrics = metrics;
        }

        boolean isStale(Clock clock) {
            return Instant.now(clock).isAfter(this.timestamp.plus(METRICS_TTL));
        }
    }
}

