/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.service.VespaService;
import com.google.inject.Inject;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Transport;
import com.yahoo.log.LogLevel;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigSentinelClient {
    private static final Logger log = Logger.getLogger(ConfigSentinelClient.class.getName());

    @Inject
    public ConfigSentinelClient() {
    }

    synchronized void updateServiceStatuses(List<VespaService> services) {
        try {
            this.setStatus(services);
        }
        catch (Exception e) {
            log.log((Level)LogLevel.ERROR, "Unable to update service pids from sentinel", e);
        }
    }

    synchronized void ping(VespaService s) {
        ArrayList<VespaService> services = new ArrayList<VespaService>();
        services.add(s);
        log.log((Level)LogLevel.DEBUG, "Ping for service " + s);
        try {
            this.setStatus(services);
        }
        catch (Exception e) {
            log.log((Level)LogLevel.ERROR, "Unable to update service pids from sentinel", e);
        }
    }

    protected synchronized void setStatus(List<VespaService> services) throws Exception {
        String line;
        String in = this.sentinelLs();
        BufferedReader reader = new BufferedReader(new StringReader(in));
        ArrayList<VespaService> updatedServices = new ArrayList<VespaService>();
        while ((line = reader.readLine()) != null && !line.equals("")) {
            VespaService s = ConfigSentinelClient.parseServiceString(line, services);
            if (s == null) continue;
            updatedServices.add(s);
        }
        for (VespaService s : services) {
            if (s.getServiceName().equals("configserver") || updatedServices.contains(s)) continue;
            log.log((Level)LogLevel.DEBUG, "Service " + s + " is no longer found with sentinel - setting alive = false");
            s.setAlive(false);
        }
        reader.close();
    }

    static VespaService parseServiceString(String line, List<VespaService> services) {
        String[] parts = line.split(" ");
        if (parts.length < 3) {
            return null;
        }
        String name = parts[0];
        int pid = -1;
        String state = null;
        VespaService service = null;
        for (VespaService s : services) {
            if (s.getInstanceName().compareToIgnoreCase(name) != 0) continue;
            service = s;
            break;
        }
        if (service == null) {
            return service;
        }
        for (int i = 1; i < parts.length; ++i) {
            String[] keyValue = parts[i].split("=");
            String key = keyValue[0];
            String value = keyValue[1];
            if (key.equals("state")) {
                state = value;
                continue;
            }
            if (!key.equals("pid")) continue;
            pid = Integer.parseInt(value);
        }
        if (state != null) {
            service.setState(state);
            if (pid >= 0 && "RUNNING".equals(state)) {
                service.setAlive(true);
                service.setPid(pid);
            } else {
                service.setAlive(false);
            }
        } else {
            service.setAlive(false);
        }
        return service;
    }

    String sentinelLs() {
        String servicelist = "";
        Supervisor supervisor = new Supervisor(new Transport());
        int rpcPort = 19097;
        Spec spec = new Spec("localhost", rpcPort);
        Target connection = supervisor.connect(spec);
        if (connection.isValid()) {
            Request req = new Request("sentinel.ls");
            connection.invokeSync(req, 5.0);
            if (req.errorCode() == 0 && req.checkReturnTypes("s")) {
                servicelist = req.returnValues().get(0).asString();
            } else {
                log.log(LogLevel.WARNING, "Bad answer to RPC request: " + req.errorMessage());
            }
        } else {
            log.log(LogLevel.WARNING, "Could not connect to sentinel at: " + spec);
        }
        supervisor.transport().shutdown().join();
        return servicelist;
    }
}

