/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.telegraf;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class TelegrafConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "71a3b61ca0680c98a5c45d8b95e6859a";
    public static final String CONFIG_DEF_NAME = "telegraf";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.metricsproxy.telegraf";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.metricsproxy.telegraf", "isHostedVespa bool default=false", "intervalSeconds int default=60", "cloudWatch[].consumer string", "cloudWatch[].region string default=\"us-east-1\"", "cloudWatch[].namespace string", "cloudWatch[].accessKeyName string default=\"\"", "cloudWatch[].secretKeyName string default=\"\"", "cloudWatch[].profile string default=\"\"", "cloudWatch[].file string default=\"\""};
    private final BooleanNode isHostedVespa;
    private final IntegerNode intervalSeconds;
    private final InnerNodeVector<CloudWatch> cloudWatch;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public TelegrafConfig(Builder builder) {
        this(builder, true);
    }

    private TelegrafConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for telegraf must be initialized: " + builder.__uninitialized);
        }
        this.isHostedVespa = builder.isHostedVespa == null ? new BooleanNode(false) : new BooleanNode(builder.isHostedVespa.booleanValue());
        this.intervalSeconds = builder.intervalSeconds == null ? new IntegerNode(60) : new IntegerNode(builder.intervalSeconds.intValue());
        this.cloudWatch = CloudWatch.createVector(builder.cloudWatch);
    }

    public boolean isHostedVespa() {
        return this.isHostedVespa.value();
    }

    public int intervalSeconds() {
        return this.intervalSeconds.value();
    }

    public List<CloudWatch> cloudWatch() {
        return this.cloudWatch;
    }

    public CloudWatch cloudWatch(int i) {
        return (CloudWatch)((Object)this.cloudWatch.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(TelegrafConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class CloudWatch
    extends InnerNode {
        private final StringNode consumer;
        private final StringNode region;
        private final StringNode namespace;
        private final StringNode accessKeyName;
        private final StringNode secretKeyName;
        private final StringNode profile;
        private final StringNode file;

        public CloudWatch(Builder builder) {
            this(builder, true);
        }

        private CloudWatch(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for telegraf.cloudWatch[] must be initialized: " + builder.__uninitialized);
            }
            this.consumer = builder.consumer == null ? new StringNode() : new StringNode(builder.consumer);
            this.region = builder.region == null ? new StringNode("us-east-1") : new StringNode(builder.region);
            this.namespace = builder.namespace == null ? new StringNode() : new StringNode(builder.namespace);
            this.accessKeyName = builder.accessKeyName == null ? new StringNode(TelegrafConfig.CONFIG_DEF_VERSION) : new StringNode(builder.accessKeyName);
            this.secretKeyName = builder.secretKeyName == null ? new StringNode(TelegrafConfig.CONFIG_DEF_VERSION) : new StringNode(builder.secretKeyName);
            this.profile = builder.profile == null ? new StringNode(TelegrafConfig.CONFIG_DEF_VERSION) : new StringNode(builder.profile);
            this.file = builder.file == null ? new StringNode(TelegrafConfig.CONFIG_DEF_VERSION) : new StringNode(builder.file);
        }

        public String consumer() {
            return this.consumer.value();
        }

        public String region() {
            return this.region.value();
        }

        public String namespace() {
            return this.namespace.value();
        }

        public String accessKeyName() {
            return this.accessKeyName.value();
        }

        public String secretKeyName() {
            return this.secretKeyName.value();
        }

        public String profile() {
            return this.profile.value();
        }

        public String file() {
            return this.file.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(CloudWatch newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("cloudWatch");
            return changes;
        }

        private static InnerNodeVector<CloudWatch> createVector(List<Builder> builders) {
            ArrayList<CloudWatch> elems = new ArrayList<CloudWatch>();
            for (Builder b : builders) {
                elems.add(new CloudWatch(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("consumer", "namespace"));
            private String consumer = null;
            private String region = null;
            private String namespace = null;
            private String accessKeyName = null;
            private String secretKeyName = null;
            private String profile = null;
            private String file = null;

            public Builder() {
            }

            public Builder(CloudWatch config) {
                this.consumer(config.consumer());
                this.region(config.region());
                this.namespace(config.namespace());
                this.accessKeyName(config.accessKeyName());
                this.secretKeyName(config.secretKeyName());
                this.profile(config.profile());
                this.file(config.file());
            }

            private Builder override(Builder __superior) {
                if (__superior.consumer != null) {
                    this.consumer(__superior.consumer);
                }
                if (__superior.region != null) {
                    this.region(__superior.region);
                }
                if (__superior.namespace != null) {
                    this.namespace(__superior.namespace);
                }
                if (__superior.accessKeyName != null) {
                    this.accessKeyName(__superior.accessKeyName);
                }
                if (__superior.secretKeyName != null) {
                    this.secretKeyName(__superior.secretKeyName);
                }
                if (__superior.profile != null) {
                    this.profile(__superior.profile);
                }
                if (__superior.file != null) {
                    this.file(__superior.file);
                }
                return this;
            }

            public Builder consumer(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.consumer = __value;
                this.__uninitialized.remove("consumer");
                return this;
            }

            public Builder region(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.region = __value;
                return this;
            }

            public Builder namespace(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.namespace = __value;
                this.__uninitialized.remove("namespace");
                return this;
            }

            public Builder accessKeyName(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.accessKeyName = __value;
                return this;
            }

            public Builder secretKeyName(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.secretKeyName = __value;
                return this;
            }

            public Builder profile(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.profile = __value;
                return this;
            }

            public Builder file(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.file = __value;
                return this;
            }

            public CloudWatch build() {
                return new CloudWatch(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean isHostedVespa = null;
        private Integer intervalSeconds = null;
        public List<CloudWatch.Builder> cloudWatch = new ArrayList<CloudWatch.Builder>();

        public Builder() {
        }

        public Builder(TelegrafConfig config) {
            this.isHostedVespa(config.isHostedVespa());
            this.intervalSeconds(config.intervalSeconds());
            for (CloudWatch c : config.cloudWatch()) {
                this.cloudWatch(new CloudWatch.Builder(c));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.isHostedVespa != null) {
                this.isHostedVespa(__superior.isHostedVespa);
            }
            if (__superior.intervalSeconds != null) {
                this.intervalSeconds(__superior.intervalSeconds);
            }
            if (!__superior.cloudWatch.isEmpty()) {
                this.cloudWatch.addAll(__superior.cloudWatch);
            }
            return this;
        }

        public Builder isHostedVespa(boolean __value) {
            this.isHostedVespa = __value;
            return this;
        }

        private Builder isHostedVespa(String __value) {
            return this.isHostedVespa(Boolean.valueOf(__value));
        }

        public Builder intervalSeconds(int __value) {
            this.intervalSeconds = __value;
            return this;
        }

        private Builder intervalSeconds(String __value) {
            return this.intervalSeconds(Integer.valueOf(__value));
        }

        public Builder cloudWatch(CloudWatch.Builder __builder) {
            this.cloudWatch.add(__builder);
            return this;
        }

        public Builder cloudWatch(List<CloudWatch.Builder> __builders) {
            this.cloudWatch = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return TelegrafConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return TelegrafConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return TelegrafConfig.CONFIG_DEF_NAMESPACE;
        }

        public TelegrafConfig build() {
            return new TelegrafConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

