/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.service;

import ai.vespa.metricsproxy.service.VespaService;
import com.google.inject.Inject;
import com.yahoo.log.LogLevel;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigSentinelClient {
    private static final Logger log = Logger.getLogger(ConfigSentinelClient.class.getName());
    private final CmdClient client = new CmdClient();

    @Inject
    public ConfigSentinelClient() {
    }

    synchronized void updateServiceStatuses(List<VespaService> services) {
        try {
            this.setStatus(services);
        }
        catch (Exception e) {
            log.log((Level)LogLevel.ERROR, "Unable to update service pids from sentinel", e);
        }
    }

    synchronized void ping(VespaService s) {
        ArrayList<VespaService> services = new ArrayList<VespaService>();
        services.add(s);
        log.log((Level)LogLevel.DEBUG, "Ping for service " + s);
        try {
            this.setStatus(services);
        }
        catch (Exception e) {
            log.log((Level)LogLevel.ERROR, "Unable to update service pids from sentinel", e);
        }
    }

    protected synchronized void setStatus(List<VespaService> services) throws Exception {
        String line;
        this.client.connect();
        InputStream in = this.client.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        ArrayList<VespaService> updatedServices = new ArrayList<VespaService>();
        while ((line = reader.readLine()) != null && !line.equals("")) {
            VespaService s = ConfigSentinelClient.parseServiceString(line, services);
            if (s == null) continue;
            updatedServices.add(s);
        }
        for (VespaService s : services) {
            if (s.getServiceName().equals("configserver") || updatedServices.contains(s)) continue;
            log.log((Level)LogLevel.DEBUG, "Service " + s + " is no longer found with sentinel - setting alive = false");
            s.setAlive(false);
        }
        reader.close();
        this.client.disconnect();
    }

    static VespaService parseServiceString(String line, List<VespaService> services) {
        String[] parts = line.split(" ");
        if (parts.length < 3) {
            return null;
        }
        String name = parts[0];
        int pid = -1;
        String state = null;
        VespaService service = null;
        for (VespaService s : services) {
            if (s.getInstanceName().compareToIgnoreCase(name) != 0) continue;
            service = s;
            break;
        }
        if (service == null) {
            return service;
        }
        for (int i = 1; i < parts.length; ++i) {
            String[] keyValue = parts[i].split("=");
            String key = keyValue[0];
            String value = keyValue[1];
            if (key.equals("state")) {
                state = value;
                continue;
            }
            if (!key.equals("pid")) continue;
            pid = Integer.parseInt(value);
        }
        if (state != null) {
            service.setState(state);
            if (pid >= 0 && "RUNNING".equals(state)) {
                service.setAlive(true);
                service.setPid(pid);
            } else {
                service.setAlive(false);
            }
        } else {
            service.setAlive(false);
        }
        return service;
    }

    static class CmdClient {
        Process proc;

        CmdClient() {
        }

        void connect() {
            String[] args = new String[]{"vespa-sentinel-cmd", "list"};
            try {
                this.proc = Runtime.getRuntime().exec(args);
            }
            catch (Exception e) {
                log.log(LogLevel.WARNING, "could not run vespa-sentinel-cmd: " + e);
                this.proc = null;
            }
        }

        void disconnect() {
            if (this.proc.isAlive()) {
                this.proc.destroy();
            }
            this.proc = null;
        }

        InputStream getInputStream() {
            return this.proc != null ? this.proc.getInputStream() : new ByteArrayInputStream(new byte[0]);
        }
    }
}

