/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http.application;

import ai.vespa.metricsproxy.metric.dimensions.PublicDimensions;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.processing.MetricsProcessor;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class PublicDimensionsProcessor
implements MetricsProcessor {
    private final int maxDimensions;
    private Set<DimensionId> publicDimensions = PublicDimensionsProcessor.getPublicDimensions();

    PublicDimensionsProcessor(int maxDimensions) {
        int numCommonDimensions = PublicDimensions.commonDimensions.size();
        if (numCommonDimensions > maxDimensions) {
            throw new IllegalArgumentException(String.format("The maximum number of dimensions (%d) cannot be smaller than the number of common metrics dimensions (%d).", maxDimensions, numCommonDimensions));
        }
        this.maxDimensions = maxDimensions;
    }

    @Override
    public void process(MetricsPacket.Builder builder) {
        Set<DimensionId> dimensionsToRetain = builder.getDimensionIds();
        dimensionsToRetain.retainAll(this.publicDimensions);
        if (dimensionsToRetain.size() > this.maxDimensions) {
            for (DimensionId metricDim : PublicDimensionsProcessor.getMetricDimensions()) {
                dimensionsToRetain.remove(metricDim);
                if (dimensionsToRetain.size() > this.maxDimensions) continue;
                break;
            }
        }
        builder.retainDimensions(dimensionsToRetain);
        if (builder.getDimensionIds().size() > this.maxDimensions) {
            throw new IllegalStateException(String.format("Metrics packet is only allowed to have %d dimensions, but has: %s", this.maxDimensions, builder.getDimensionIds()));
        }
    }

    static Set<DimensionId> getPublicDimensions() {
        return PublicDimensionsProcessor.toDimensionIds(PublicDimensions.publicDimensions);
    }

    static Set<DimensionId> getMetricDimensions() {
        return PublicDimensionsProcessor.toDimensionIds(PublicDimensions.metricDimensions);
    }

    static Set<DimensionId> toDimensionIds(Collection<String> dimensionNames) {
        return dimensionNames.stream().map(DimensionId::toDimensionId).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

