/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http.application;

import ai.vespa.metricsproxy.http.application.MetricsNodesConfig;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import java.net.URI;
import java.util.Objects;

public class Node {
    final String nodeId;
    final String host;
    final int port;
    final String path;
    private final String metricsUriBase;

    public Node(MetricsNodesConfig.Node nodeConfig) {
        this(nodeConfig.nodeId(), nodeConfig.hostname(), nodeConfig.metricsPort(), nodeConfig.metricsPath());
    }

    public Node(String nodeId, String host, int port, String path) {
        Objects.requireNonNull(nodeId, "Null configId is not allowed");
        Objects.requireNonNull(host, "Null host is not allowed");
        Objects.requireNonNull(path, "Null path is not allowed");
        this.nodeId = nodeId;
        this.host = host;
        this.port = port;
        this.path = path;
        this.metricsUriBase = "http://" + host + ":" + port + path;
    }

    public String getName() {
        return this.nodeId;
    }

    URI metricsUri(ConsumerId consumer) {
        return URI.create(this.metricsUriBase + "?consumer=" + consumer.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return this.port == node.port && this.nodeId.equals(node.nodeId) && this.host.equals(node.host);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.host, this.port);
    }
}

