/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http;

import ai.vespa.metricsproxy.http.ErrorResponse;
import ai.vespa.metricsproxy.http.JsonResponse;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.restapi.Path;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class HttpHandlerBase
extends ThreadedHttpRequestHandler {
    protected HttpHandlerBase(Executor executor) {
        super(executor);
    }

    protected abstract Optional<HttpResponse> doHandle(URI var1, Path var2, String var3);

    public final HttpResponse handle(HttpRequest request) {
        if (request.getMethod() != HttpRequest.Method.GET) {
            return new JsonResponse(405, "Only GET is supported");
        }
        Path path = new Path(request.getUri());
        return this.doHandle(request.getUri(), path, this.getConsumer(request)).orElse(new ErrorResponse(404, "No content at given path"));
    }

    private String getConsumer(HttpRequest request) {
        return request.getProperty("consumer");
    }

    protected JsonResponse resourceListResponse(URI requestUri, List<String> resources) {
        try {
            return new JsonResponse(200, HttpHandlerBase.resourceList(requestUri, resources));
        }
        catch (JSONException e) {
            this.log.log(Level.WARNING, "Bad JSON construction in generated resource list for " + requestUri.getPath(), e);
            return new ErrorResponse(500, "An error occurred when generating the list of api resources.");
        }
    }

    private static String resourceList(URI requestUri, List<String> resources) throws JSONException {
        int port = requestUri.getPort();
        String host = requestUri.getHost();
        StringBuilder base = new StringBuilder("http://");
        base.append(host);
        if (port >= 0) {
            base.append(":").append(port);
        }
        String uriBase = base.toString();
        JSONArray linkList = new JSONArray();
        for (String api : resources) {
            JSONObject resource = new JSONObject();
            resource.put("url", (Object)(uriBase + api));
            linkList.put((Object)resource);
        }
        return new JSONObject().put("resources", (Object)linkList).toString(4);
    }
}

