/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http;

import ai.vespa.metricsproxy.core.MetricsConsumers;
import ai.vespa.metricsproxy.core.MetricsManager;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.json.JsonRenderingException;
import ai.vespa.metricsproxy.service.VespaServices;
import java.time.Instant;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ValuesFetcher {
    private static final Logger log = Logger.getLogger(ValuesFetcher.class.getName());
    public static final ConsumerId DEFAULT_PUBLIC_CONSUMER_ID = ConsumerId.toConsumerId("default");
    private final MetricsManager metricsManager;
    private final VespaServices vespaServices;
    private final MetricsConsumers metricsConsumers;

    public ValuesFetcher(MetricsManager metricsManager, VespaServices vespaServices, MetricsConsumers metricsConsumers) {
        this.metricsManager = metricsManager;
        this.vespaServices = vespaServices;
        this.metricsConsumers = metricsConsumers;
    }

    public List<MetricsPacket> fetch(String requestedConsumer) throws JsonRenderingException {
        ConsumerId consumer = this.getConsumerOrDefault(requestedConsumer);
        return this.fetchAllMetrics().stream().filter(metricsPacket -> metricsPacket.consumers().contains(consumer)).collect(Collectors.toList());
    }

    public List<MetricsPacket> fetchAllMetrics() throws JsonRenderingException {
        return this.metricsManager.getMetrics(this.vespaServices.getVespaServices(), Instant.now());
    }

    private ConsumerId getConsumerOrDefault(String consumer) {
        if (consumer == null) {
            return DEFAULT_PUBLIC_CONSUMER_ID;
        }
        ConsumerId consumerId = ConsumerId.toConsumerId(consumer);
        if (!this.metricsConsumers.getAllConsumers().contains(consumerId)) {
            log.info("No consumer with id '" + consumer + "' - using the default consumer instead.");
            return DEFAULT_PUBLIC_CONSUMER_ID;
        }
        return consumerId;
    }
}

