/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.http;

import ai.vespa.metricsproxy.http.JsonResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ErrorResponse
extends JsonResponse {
    private static Logger log = Logger.getLogger(ErrorResponse.class.getName());
    private static ObjectMapper objectMapper = new ObjectMapper();

    public ErrorResponse(int code, String message) {
        super(code, ErrorResponse.asErrorJson(message));
    }

    static String asErrorJson(String message) {
        try {
            return objectMapper.writeValueAsString(Map.of("error", message));
        }
        catch (JsonProcessingException e) {
            log.log(Level.WARNING, "Could not encode error message to json:", e);
            return "Could not encode error message to json, check the log for details.";
        }
    }
}

