/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.node;

import ai.vespa.metricsproxy.core.MetricsManager;
import ai.vespa.metricsproxy.metric.dimensions.ApplicationDimensions;
import ai.vespa.metricsproxy.metric.dimensions.NodeDimensions;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.node.CoredumpMetricGatherer;
import ai.vespa.metricsproxy.node.FileWrapper;
import ai.vespa.metricsproxy.node.HostLifeGatherer;
import ai.vespa.metricsproxy.node.ServiceHealthGatherer;
import ai.vespa.metricsproxy.service.SystemPollerProvider;
import ai.vespa.metricsproxy.service.VespaServices;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class NodeMetricGatherer {
    private final VespaServices vespaServices;
    private final ApplicationDimensions applicationDimensions;
    private final NodeDimensions nodeDimensions;
    private final MetricsManager metricsManager;

    @Inject
    public NodeMetricGatherer(MetricsManager metricsManager, VespaServices vespaServices, ApplicationDimensions applicationDimensions, NodeDimensions nodeDimensions) {
        this.metricsManager = metricsManager;
        this.vespaServices = vespaServices;
        this.applicationDimensions = applicationDimensions;
        this.nodeDimensions = nodeDimensions;
    }

    public List<MetricsPacket> gatherMetrics() {
        FileWrapper fileWrapper = new FileWrapper();
        ArrayList<MetricsPacket.Builder> metricPacketBuilders = new ArrayList<MetricsPacket.Builder>();
        metricPacketBuilders.add(CoredumpMetricGatherer.gatherCoredumpMetrics(fileWrapper));
        metricPacketBuilders.addAll(ServiceHealthGatherer.gatherServiceHealthMetrics(this.vespaServices));
        if (SystemPollerProvider.runningOnLinux()) {
            metricPacketBuilders.add(HostLifeGatherer.gatherHostLifeMetrics(fileWrapper));
        }
        return metricPacketBuilders.stream().map(metricPacketBuilder -> metricPacketBuilder.putDimensionsIfAbsent(this.applicationDimensions.getDimensions()).putDimensionsIfAbsent(this.nodeDimensions.getDimensions()).putDimensionsIfAbsent(this.metricsManager.getExtraDimensions()).build()).collect(Collectors.toList());
    }
}

