/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.core;

import ai.vespa.metricsproxy.core.VespaMetrics;
import ai.vespa.metricsproxy.metric.ExternalMetrics;
import ai.vespa.metricsproxy.metric.dimensions.ApplicationDimensions;
import ai.vespa.metricsproxy.metric.dimensions.NodeDimensions;
import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.DimensionId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.service.VespaService;
import ai.vespa.metricsproxy.service.VespaServices;
import com.yahoo.component.Vtag;
import com.yahoo.log.LogLevel;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MetricsManager {
    private static Logger log = Logger.getLogger(MetricsManager.class.getName());
    static final DimensionId VESPA_VERSION = DimensionId.toDimensionId("vespaVersion");
    private final VespaServices vespaServices;
    private final VespaMetrics vespaMetrics;
    private final ExternalMetrics externalMetrics;
    private final ApplicationDimensions applicationDimensions;
    private final NodeDimensions nodeDimensions;
    private volatile Map<DimensionId, String> extraDimensions = new HashMap<DimensionId, String>();

    public MetricsManager(VespaServices vespaServices, VespaMetrics vespaMetrics, ExternalMetrics externalMetrics, ApplicationDimensions applicationDimensions, NodeDimensions nodeDimensions) {
        this.vespaServices = vespaServices;
        this.vespaMetrics = vespaMetrics;
        this.externalMetrics = externalMetrics;
        this.applicationDimensions = applicationDimensions;
        this.nodeDimensions = nodeDimensions;
    }

    public String getMetricNamesForServiceAndConsumer(String service, ConsumerId consumer) {
        return this.vespaMetrics.getMetricNames(this.vespaServices.getMonitoringServices(service), consumer);
    }

    public String getMetricsByConfigId(String configId) {
        List<VespaService> services = this.vespaServices.getInstancesById(configId);
        this.vespaServices.updateServices(services);
        return this.vespaMetrics.getMetricsAsString(services);
    }

    public List<MetricsPacket> getMetrics(List<VespaService> services, Instant startTime) {
        if (services.isEmpty()) {
            return Collections.emptyList();
        }
        log.log((Level)LogLevel.DEBUG, () -> "Updating services prior to fetching metrics, number of services= " + services.size());
        this.vespaServices.updateServices(services);
        List<MetricsPacket.Builder> result = this.vespaMetrics.getMetrics(services);
        log.log((Level)LogLevel.DEBUG, () -> "Got " + result.size() + " metrics packets for vespa services.");
        List externalPackets = this.externalMetrics.getMetrics().stream().filter(MetricsPacket.Builder::hasMetrics).collect(Collectors.toList());
        log.log((Level)LogLevel.DEBUG, () -> "Got " + externalPackets.size() + " external metrics packets with whitelisted metrics.");
        result.addAll(externalPackets);
        return result.stream().map(builder -> builder.putDimensionsIfAbsent(this.getGlobalDimensions())).map(builder -> builder.putDimensionsIfAbsent(this.extraDimensions)).map(builder -> MetricsManager.adjustTimestamp(builder, startTime)).map(MetricsPacket.Builder::build).collect(Collectors.toList());
    }

    private Map<DimensionId, String> getGlobalDimensions() {
        LinkedHashMap<DimensionId, String> globalDimensions = new LinkedHashMap<DimensionId, String>(this.applicationDimensions.getDimensions());
        globalDimensions.putAll(this.nodeDimensions.getDimensions());
        globalDimensions.put(VESPA_VERSION, Vtag.currentVersion.toFullString());
        return globalDimensions;
    }

    static MetricsPacket.Builder adjustTimestamp(MetricsPacket.Builder builder, Instant startTime) {
        Duration age = Duration.between(startTime, builder.getTimestamp());
        if (age.abs().minusMinutes(1L).isNegative()) {
            builder.timestamp(startTime.getEpochSecond());
        }
        return builder;
    }

    public List<MetricsPacket> getHealthMetrics(List<VespaService> services) {
        if (services.isEmpty()) {
            return Collections.emptyList();
        }
        this.vespaServices.updateServices(services);
        return this.vespaMetrics.getHealthMetrics(services);
    }

    public void setExtraMetrics(List<MetricsPacket.Builder> packets) {
        this.extraDimensions = ExternalMetrics.extractConfigserverDimensions(packets);
        this.externalMetrics.setExtraMetrics(packets);
    }

    public Map<DimensionId, String> getExtraDimensions() {
        return this.extraDimensions;
    }

    public String getAllVespaServices() {
        return this.vespaServices.getVespaServices().stream().map(VespaService::getServiceName).distinct().collect(Collectors.joining(" "));
    }
}

