/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.node;

import ai.vespa.metricsproxy.metric.model.ConsumerId;
import ai.vespa.metricsproxy.metric.model.MetricId;
import ai.vespa.metricsproxy.metric.model.MetricsPacket;
import ai.vespa.metricsproxy.metric.model.ServiceId;
import ai.vespa.metricsproxy.node.FileWrapper;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Set;

public class HostLifeGatherer {
    private static final Path UPTIME_PATH = Path.of("/proc", new String[0]);

    protected static MetricsPacket.Builder gatherHostLifeMetrics(FileWrapper fileWrapper) {
        long upTime;
        int statusCode = 0;
        String statusMessage = "OK";
        try {
            upTime = fileWrapper.getFileAgeInSeconds(UPTIME_PATH);
        }
        catch (IOException e) {
            upTime = 0L;
            statusCode = 1;
            statusMessage = e.getMessage();
        }
        return new MetricsPacket.Builder(ServiceId.toServiceId("host_life")).timestamp(Instant.now().getEpochSecond()).statusMessage(statusMessage).statusCode(statusCode).putMetric(MetricId.toMetricId("uptime"), upTime).putMetric(MetricId.toMetricId("alive"), 1).addConsumers(Set.of(ConsumerId.toConsumerId("Vespa")));
    }
}

