/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus;

import com.yahoo.concurrent.SystemTimer;
import com.yahoo.messagebus.Routable;
import com.yahoo.messagebus.routing.Route;

public abstract class Message
extends Routable {
    private Route route = null;
    private long timeReceived = 0L;
    private long timeRemaining = 0L;
    private boolean retryEnabled = true;
    private int retry = 0;

    @Override
    public void swapState(Routable rhs) {
        super.swapState(rhs);
        if (rhs instanceof Message) {
            Message msg = (Message)rhs;
            Route route = this.route;
            this.route = msg.route;
            msg.route = route;
            boolean retryEnabled = this.retryEnabled;
            this.retryEnabled = msg.retryEnabled;
            msg.retryEnabled = retryEnabled;
            int retry = this.retry;
            this.retry = msg.retry;
            msg.retry = retry;
            long timeReceived = this.timeReceived;
            this.timeReceived = msg.timeReceived;
            msg.timeReceived = timeReceived;
            long timeRemaining = this.timeRemaining;
            this.timeRemaining = msg.timeRemaining;
            msg.timeRemaining = timeRemaining;
        }
    }

    public Route getRoute() {
        return this.route;
    }

    public Message setRoute(Route route) {
        this.route = new Route(route);
        return this;
    }

    public long getTimeReceived() {
        return this.timeReceived;
    }

    public Message setTimeReceived(long timeReceived) {
        this.timeReceived = timeReceived;
        return this;
    }

    public Message setTimeReceivedNow() {
        return this.setTimeReceived(SystemTimer.INSTANCE.milliTime());
    }

    public long getTimeRemaining() {
        return this.timeRemaining;
    }

    public Message setTimeRemaining(long timeRemaining) {
        this.timeRemaining = timeRemaining;
        return this;
    }

    public long getTimeRemainingNow() {
        return this.timeRemaining - (SystemTimer.INSTANCE.milliTime() - this.timeReceived);
    }

    public boolean isExpired() {
        return this.getTimeRemainingNow() <= 0L;
    }

    public boolean hasSequenceId() {
        return false;
    }

    public long getSequenceId() {
        return 0L;
    }

    public boolean hasBucketSequence() {
        return false;
    }

    public long getBucketSequence() {
        return 0L;
    }

    public int getApproxSize() {
        return 1;
    }

    public void setRetryEnabled(boolean enabled) {
        this.retryEnabled = enabled;
    }

    public boolean getRetryEnabled() {
        return this.retryEnabled;
    }

    public int getRetry() {
        return this.retry;
    }

    public Message setRetry(int retry) {
        this.retry = retry;
        return this;
    }
}

