/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import com.yahoo.messagebus.routing.ApplicationSpec;
import com.yahoo.messagebus.routing.HopSpec;
import com.yahoo.messagebus.routing.RouteSpec;
import com.yahoo.messagebus.routing.RoutingSpec;
import com.yahoo.text.Utf8String;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RoutingTableSpec {
    private final String protocol;
    private final List<HopSpec> hops = new ArrayList<HopSpec>();
    private final List<RouteSpec> routes = new ArrayList<RouteSpec>();
    private final boolean verify;

    public RoutingTableSpec(String protocol) {
        this(protocol, true);
    }

    public RoutingTableSpec(Utf8String protocol) {
        this(protocol.toString(), true);
    }

    public RoutingTableSpec(String protocol, boolean verify) {
        this.protocol = protocol;
        this.verify = verify;
    }

    public RoutingTableSpec(RoutingTableSpec obj) {
        this.protocol = obj.protocol;
        this.verify = obj.verify;
        for (HopSpec hop : obj.hops) {
            this.hops.add(new HopSpec(hop));
        }
        for (RouteSpec route : obj.routes) {
            this.routes.add(new RouteSpec(route));
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean hasHops() {
        return !this.hops.isEmpty();
    }

    public boolean hasHop(String hopName) {
        for (HopSpec hop : this.hops) {
            if (!hop.getName().equals(hopName)) continue;
            return true;
        }
        return false;
    }

    public int getNumHops() {
        return this.hops.size();
    }

    public HopSpec getHop(int i) {
        return this.hops.get(i);
    }

    public RoutingTableSpec addHop(HopSpec hop) {
        this.hops.add(hop);
        return this;
    }

    public RoutingTableSpec setHop(int i, HopSpec hop) {
        this.hops.set(i, hop);
        return this;
    }

    public HopSpec removeHop(int i) {
        return this.hops.remove(i);
    }

    public RoutingTableSpec clearHops() {
        this.hops.clear();
        return this;
    }

    public boolean hasRoutes() {
        return !this.routes.isEmpty();
    }

    public boolean hasRoute(String routeName) {
        for (RouteSpec route : this.routes) {
            if (!route.getName().equals(routeName)) continue;
            return true;
        }
        return false;
    }

    public int getNumRoutes() {
        return this.routes.size();
    }

    public RouteSpec getRoute(int i) {
        return this.routes.get(i);
    }

    public RoutingTableSpec addRoute(RouteSpec route) {
        this.routes.add(route);
        return this;
    }

    public RoutingTableSpec setRoute(int i, RouteSpec route) {
        this.routes.set(i, route);
        return this;
    }

    public RouteSpec removeRoute(int i) {
        return this.routes.remove(i);
    }

    public RoutingTableSpec clearRoutes() {
        this.routes.clear();
        return this;
    }

    public RoutingTableSpec addHop(String name, String selector, List<String> recipients) {
        return this.addHop(new HopSpec(name, selector).addRecipients(recipients));
    }

    public RoutingTableSpec addRoute(String name, List<String> hops) {
        return this.addRoute(new RouteSpec(name).addHops(hops));
    }

    public boolean verify(ApplicationSpec app, List<String> errors) {
        if (this.verify) {
            HashMap<String, Integer> hopNames = new HashMap<String, Integer>();
            for (HopSpec hopSpec : this.hops) {
                String string = hopSpec.getName();
                int count = hopNames.containsKey(string) ? (Integer)hopNames.get(string) : 0;
                hopNames.put(string, count + 1);
                hopSpec.verify(app, this, errors);
            }
            for (Map.Entry entry : hopNames.entrySet()) {
                int n = (Integer)entry.getValue();
                if (n <= 1) continue;
                errors.add("Hop '" + (String)entry.getKey() + "' in routing table '" + this.protocol + "' is defined " + n + " times.");
            }
            HashMap<String, Integer> routeNames = new HashMap<String, Integer>();
            for (RouteSpec routeSpec : this.routes) {
                String name = routeSpec.getName();
                int count = routeNames.containsKey(name) ? (Integer)routeNames.get(name) : 0;
                routeNames.put(name, count + 1);
                routeSpec.verify(app, this, errors);
            }
            for (Map.Entry entry : routeNames.entrySet()) {
                int count = (Integer)entry.getValue();
                if (count <= 1) continue;
                errors.add("Route '" + (String)entry.getKey() + "' in routing table '" + this.protocol + "' is defined " + count + " times.");
            }
        }
        return errors.isEmpty();
    }

    public void sort() {
        Collections.sort(this.hops, new Comparator<HopSpec>(){

            @Override
            public int compare(HopSpec lhs, HopSpec rhs) {
                return lhs.getName().compareTo(rhs.getName());
            }
        });
        Collections.sort(this.routes, new Comparator<RouteSpec>(){

            @Override
            public int compare(RouteSpec lhs, RouteSpec rhs) {
                return lhs.getName().compareTo(rhs.getName());
            }
        });
    }

    public void toConfig(StringBuilder cfg, String prefix) {
        int numRoutes;
        cfg.append(prefix).append("protocol ").append(RoutingSpec.toConfigString(this.protocol)).append("\n");
        int numHops = this.hops.size();
        if (numHops > 0) {
            cfg.append(prefix).append("hop[").append(numHops).append("]\n");
            for (int i = 0; i < numHops; ++i) {
                this.hops.get(i).toConfig(cfg, prefix + "hop[" + i + "].");
            }
        }
        if ((numRoutes = this.routes.size()) > 0) {
            cfg.append(prefix).append("route[").append(numRoutes).append("]\n");
            for (int i = 0; i < numRoutes; ++i) {
                this.routes.get(i).toConfig(cfg, prefix + "route[" + i + "].");
            }
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        this.toConfig(ret, "");
        return ret.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RoutingTableSpec)) {
            return false;
        }
        RoutingTableSpec rhs = (RoutingTableSpec)obj;
        if (!this.protocol.equals(rhs.protocol)) {
            return false;
        }
        if (!this.hops.equals(rhs.hops)) {
            return false;
        }
        return this.routes.equals(rhs.routes);
    }

    public int hashCode() {
        int result = this.protocol != null ? this.protocol.hashCode() : 0;
        result = 31 * result + (this.hops != null ? this.hops.hashCode() : 0);
        result = 31 * result + (this.routes != null ? this.routes.hashCode() : 0);
        result = 31 * result + (this.verify ? 1 : 0);
        return result;
    }
}

