/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.routing;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;

public final class ApplicationSpec {
    private final HashMap<String, HashSet<String>> services = new HashMap();

    public ApplicationSpec() {
    }

    public ApplicationSpec(ApplicationSpec obj) {
        this.add(obj);
    }

    public ApplicationSpec add(ApplicationSpec app) {
        for (Map.Entry<String, HashSet<String>> entry : app.services.entrySet()) {
            String protocol = entry.getKey();
            for (String service : entry.getValue()) {
                this.addService(protocol, service);
            }
        }
        return this;
    }

    public ApplicationSpec addService(String protocol, String name) {
        if (!this.services.containsKey(protocol)) {
            this.services.put(protocol, new HashSet());
        }
        this.services.get(protocol).add(name);
        return this;
    }

    public boolean isService(String protocol, String pattern) {
        if (this.services.containsKey(protocol)) {
            Pattern regex = ApplicationSpec.toRegex(pattern);
            for (String service : this.services.get(protocol)) {
                if (!regex.matcher(service).find()) continue;
                return true;
            }
        }
        return false;
    }

    private static Pattern toRegex(String pattern) {
        StringBuilder ret = new StringBuilder();
        ret.append("^");
        for (int i = 0; i < pattern.length(); ++i) {
            ret.append(ApplicationSpec.toRegex(pattern.charAt(i)));
        }
        ret.append("$");
        return Pattern.compile(ret.toString());
    }

    private static String toRegex(char c) {
        return switch (c) {
            case '*' -> ".*";
            case '?' -> ".";
            case '$', '(', ')', '+', '.', '[', '\\', ']', '^', '{', '|', '}' -> "\\" + c;
            default -> "" + c;
        };
    }
}

